/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.BandCtrlVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.DhcpL2RelayVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.LanProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.StormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class LanProfileConfigOpenApiVO {
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [poe] should be within the range of {min}-{max}.")
    @Schema(name="poe", description="PoE should be a value as follows: 0: on, 1: off, 2: \"do not modify\"")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [poe] should be within the range of {min}-{max}.") Integer poe;
    @Schema(name="nativeNetworkId", description="Native network ID, Native Network cannot be selected from Tagged Networks or Untagged Networks.")
    @NotNull(message="Parameter [nativeNetworkId] should not be null")
    @Size(min=1)
    private @NotNull(message="Parameter [nativeNetworkId] should not be null") @Size(min=1) String nativeNetworkId;
    @Schema(name="tagNetworkIds", description="Tag network IDs")
    private List<String> tagNetworkIds;
    @Schema(name="untagNetworkIds", description="Untag network IDs")
    private List<String> untagNetworkIds;
    @Schema(name="voiceNetworkId", description="Voice Network ID")
    private String voiceNetworkId;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [dot1x] should be within the range of {min}-{max}.")
    @Schema(name="dot1x", description="Dot1x should be a value as follows: 0: force unauthorized, 1: force authorized, 2:auto")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [dot1x] should be within the range of {min}-{max}.") Integer dot1x;
    @NotNull
    @Schema(name="portIsolationEnable", description="Port-isolation enable status")
    private Boolean portIsolationEnable;
    @NotNull
    @Schema(name="lldpMedEnable", description="LLDP-MED enable status")
    private Boolean lldpMedEnable;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [bandWidthCtrlType] should be within the range of {min}-{max}")
    @Schema(name="bandWidthCtrlType", description="BandWidthCtrlType should be a value as follows: 0: off, 1: rate limit, 2: storming control")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [bandWidthCtrlType] should be within the range of {min}-{max}") Integer bandWidthCtrlType;
    @Valid
    @Schema(name="stormCtrl", description="StormCtrl")
    private StormCtrlVO stormCtrl;
    @Valid
    @Schema(name="bandCtrl", description="BandCtrl")
    private BandCtrlVO bandCtrl;
    @NotNull
    @Schema(name="spanningTreeEnable", description="SpanningTree enable status")
    private Boolean spanningTreeEnable;
    @Valid
    @Schema(name="spanningTreeSetting", description="SpanningTree Settings")
    private SpanningTreeSettingVO spanningTreeSetting;
    @NotNull
    @Schema(name="loopbackDetectEnable", description="LoopbackDetect enable status")
    private Boolean loopbackDetectEnable;
    @Schema(name="eeeEnable", description="EEE enable status")
    private Boolean eeeEnable;
    @Schema(name="flowControlEnable", description="FlowControl enable status")
    private Boolean flowControlEnable;
    @Schema(name="loopbackDetectVlanBasedEnable", description="LoopbackDetectVLANBased enable status")
    private Boolean loopbackDetectVlanBasedEnable;
    @Schema(name="igmpFastLeaveEnable", description="Indicates whether igmp fast leave is enabled")
    private Boolean igmpFastLeaveEnable;
    @Schema(name="mldFastLeaveEnable", description="Indicates whether mld fast leave is enabled")
    private Boolean mldFastLeaveEnable;
    @Schema(name="dhcpL2RelaySettings", description="DHCPL2RelaySettings")
    private DhcpL2RelayVO dhcpL2RelaySettings;
    @Schema(name="fastLeaveEnable", description="IGMP Snooping fast leave enable status")
    private Boolean fastLeaveEnable;
    @Range(min=0L, max=7L, message="Parameter [dot1pPriority] should be within the range of {min}-{max}")
    @Nullable
    @Schema(name="dot1pPriority", description="802.1p Priority")
    private @Range(min=0L, max=7L, message="Parameter [dot1pPriority] should be within the range of {min}-{max}") Integer dot1pPriority;
    @Range(min=0L, max=2L, message="Parameter [trustMode] should be within the range of {min}-{max}")
    @Nullable
    @Schema(name="trustMode", description="Trust mode")
    private @Range(min=0L, max=2L, message="Parameter [trustMode] should be within the range of {min}-{max}") Integer trustMode;

    public static LanProfileVO toLanProfileVO(LanProfileConfigOpenApiVO vo) {
        if (vo == null) {
            return null;
        }
        LanProfileVO lanProfileVO = new LanProfileVO();
        lanProfileVO.setName(vo.name);
        lanProfileVO.setPoe(vo.poe);
        lanProfileVO.setNativeNetworkId(vo.nativeNetworkId);
        lanProfileVO.setTagNetworkIds(vo.tagNetworkIds);
        lanProfileVO.setUntagNetworkIds(vo.untagNetworkIds);
        lanProfileVO.setVoiceNetworkId(vo.voiceNetworkId);
        lanProfileVO.setDot1x(vo.dot1x);
        lanProfileVO.setPortIsolationEnable(vo.portIsolationEnable);
        lanProfileVO.setLldpMedEnable(vo.lldpMedEnable);
        lanProfileVO.setBandWidthCtrlType(vo.bandWidthCtrlType);
        lanProfileVO.setStormCtrl(vo.stormCtrl);
        lanProfileVO.setBandCtrl(vo.bandCtrl);
        lanProfileVO.setSpanningTreeEnable(vo.spanningTreeEnable);
        lanProfileVO.setSpanningTreeSetting(vo.spanningTreeSetting);
        lanProfileVO.setLoopbackDetectEnable(vo.loopbackDetectEnable);
        lanProfileVO.setEeeEnable(vo.eeeEnable);
        lanProfileVO.setFlowControlEnable(vo.flowControlEnable);
        lanProfileVO.setLoopbackDetectVlanBasedEnable(vo.loopbackDetectVlanBasedEnable);
        lanProfileVO.setIgmpFastLeaveEnable(vo.igmpFastLeaveEnable);
        lanProfileVO.setMldFastLeaveEnable(vo.mldFastLeaveEnable);
        lanProfileVO.setDhcpL2RelaySettings(vo.dhcpL2RelaySettings);
        lanProfileVO.setFastLeaveEnable(vo.fastLeaveEnable);
        lanProfileVO.setDot1pPriority(vo.dot1pPriority);
        lanProfileVO.setTrustMode(vo.trustMode);
        return lanProfileVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public String getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public List<String> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public List<String> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public String getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public StormCtrlVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public BandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public DhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Nullable
    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Nullable
    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPoe(Integer poe) {
        this.poe = poe;
    }

    @Generated
    public void setNativeNetworkId(String nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
    }

    @Generated
    public void setTagNetworkIds(List<String> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
    }

    @Generated
    public void setUntagNetworkIds(List<String> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
    }

    @Generated
    public void setVoiceNetworkId(String voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
    }

    @Generated
    public void setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
    }

    @Generated
    public void setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
    }

    @Generated
    public void setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
    }

    @Generated
    public void setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
    }

    @Generated
    public void setStormCtrl(StormCtrlVO stormCtrl) {
        this.stormCtrl = stormCtrl;
    }

    @Generated
    public void setBandCtrl(BandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
    }

    @Generated
    public void setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
    }

    @Generated
    public void setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
    }

    @Generated
    public void setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
    }

    @Generated
    public void setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
    }

    @Generated
    public void setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
    }

    @Generated
    public void setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
    }

    @Generated
    public void setDhcpL2RelaySettings(DhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
    }

    @Generated
    public void setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
    }

    @Generated
    public void setDot1pPriority(@Nullable Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
    }

    @Generated
    public void setTrustMode(@Nullable Integer trustMode) {
        this.trustMode = trustMode;
    }

    @Generated
    public String toString() {
        return "LanProfileConfigOpenApiVO(name=" + this.getName() + ", poe=" + this.getPoe() + ", nativeNetworkId=" + this.getNativeNetworkId() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", dot1x=" + this.getDot1x() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", stormCtrl=" + this.getStormCtrl() + ", bandCtrl=" + this.getBandCtrl() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ")";
    }

    @Generated
    public LanProfileConfigOpenApiVO(String name, Integer poe, String nativeNetworkId, List<String> tagNetworkIds, List<String> untagNetworkIds, String voiceNetworkId, Integer dot1x, Boolean portIsolationEnable, Boolean lldpMedEnable, Integer bandWidthCtrlType, StormCtrlVO stormCtrl, BandCtrlVO bandCtrl, Boolean spanningTreeEnable, SpanningTreeSettingVO spanningTreeSetting, Boolean loopbackDetectEnable, Boolean eeeEnable, Boolean flowControlEnable, Boolean loopbackDetectVlanBasedEnable, Boolean igmpFastLeaveEnable, Boolean mldFastLeaveEnable, DhcpL2RelayVO dhcpL2RelaySettings, Boolean fastLeaveEnable, @Nullable Integer dot1pPriority, @Nullable Integer trustMode) {
        this.name = name;
        this.poe = poe;
        this.nativeNetworkId = nativeNetworkId;
        this.tagNetworkIds = tagNetworkIds;
        this.untagNetworkIds = untagNetworkIds;
        this.voiceNetworkId = voiceNetworkId;
        this.dot1x = dot1x;
        this.portIsolationEnable = portIsolationEnable;
        this.lldpMedEnable = lldpMedEnable;
        this.bandWidthCtrlType = bandWidthCtrlType;
        this.stormCtrl = stormCtrl;
        this.bandCtrl = bandCtrl;
        this.spanningTreeEnable = spanningTreeEnable;
        this.spanningTreeSetting = spanningTreeSetting;
        this.loopbackDetectEnable = loopbackDetectEnable;
        this.eeeEnable = eeeEnable;
        this.flowControlEnable = flowControlEnable;
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        this.fastLeaveEnable = fastLeaveEnable;
        this.dot1pPriority = dot1pPriority;
        this.trustMode = trustMode;
    }

    @Generated
    public LanProfileConfigOpenApiVO() {
    }
}

