/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="dhcp settings")
public class DhcpSettingsOpenApiVO {
    @Schema(name="enable", description="When value is true, DHCP server is enabled")
    private Boolean enable;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Range Start IP")
    @Schema(name="ipaddrStart", description="DHCP Range Start IP. Must use ipRangePool field If want to configure multiple DHCP Ranges.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Range Start IP") String ipaddrStart;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Range End IP")
    @Schema(name="ipaddrEnd", description="DHCP Range End IP. Must use ipRangePool field If want to configure multiple DHCP Ranges.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Range End IP") String ipaddrEnd;
    @Schema(name="ipRangeStart", description="The specific format value of Gateway Subnet start IP")
    private Long ipRangeStart;
    @Schema(name="ipRangeEnd", description="The specific format value of Gateway Subnet End IP")
    private Long ipRangeEnd;
    @Schema(name="dhcpns", description="Setup DHCP server: \"auto\" or \"manual\"")
    private String dhcpns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP1")
    @Schema(name="priDns", description="When DHCPs are \"manual\", primary DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP1") String priDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP2")
    @Schema(name="sndDns", description="When DHCPs are \"manual\", second DNS Server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Name Server IP2") String sndDns;
    @Range(min=2L, max=2880L, message="Value of leasetime is from 2 to 2880.")
    @Schema(name="leasetime", description="Valid value is from 2 to 2880")
    private @Range(min=2L, max=2880L, message="Value of leasetime is from 2 to 2880.") Integer leasetime;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Gateway IP")
    @Schema(name="gateway", description="Manual Setup of DHCP Gateway IP")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Gateway IP") String gateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Omada Controller IP")
    @Schema(name="hostIP", description="DHCP Omada Controller IP")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Omada Controller IP") String hostIP;
    @Pattern(regexp="^[\\041-\\0176]{0,50}$", message="Parameter [option60] should be visible ASCII, between 0 and 50.")
    @Schema(name="option60", description="Option60 should be between 0 and 50, which is used to optionally identify the vendor type and configuration of a DHCP client.")
    private @Pattern(regexp="^[\\041-\\0176]{0,50}$", message="Parameter [option60] should be visible ASCII, between 0 and 50.") String option60;
    @Pattern(regexp="^[\\041-\\0176]{0,128}$", message="Parameter [option66] should be visible ASCII, between 0 and 128.")
    @Schema(name="option66", description="The Option66 should be between 0 and 128, which specifies the TFTP server information and supports a single TFTP server IP address.")
    private @Pattern(regexp="^[\\041-\\0176]{0,128}$", message="Parameter [option66] should be visible ASCII, between 0 and 128.") String option66;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid option138 IP")
    @Schema(name="option138", description="The option138 should be valid IP address, which is used in discovering the devices by the Omada controller.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid option138 IP") String option138;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Next Server IP")
    @Schema(name="dhcpNextServer", description="The dhcpNextServer should be valid IP address, which is used in optional set next DHCP server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DHCP Next Server IP") String dhcpNextServer;
    @Schema(name="options", description="User custom DHCP options")
    private List<DhcpOptionOpenApiVO> options;

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getIpaddrStart() {
        return this.ipaddrStart;
    }

    @Generated
    public String getIpaddrEnd() {
        return this.ipaddrEnd;
    }

    @Generated
    public Long getIpRangeStart() {
        return this.ipRangeStart;
    }

    @Generated
    public Long getIpRangeEnd() {
        return this.ipRangeEnd;
    }

    @Generated
    public String getDhcpns() {
        return this.dhcpns;
    }

    @Generated
    public String getPriDns() {
        return this.priDns;
    }

    @Generated
    public String getSndDns() {
        return this.sndDns;
    }

    @Generated
    public Integer getLeasetime() {
        return this.leasetime;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getHostIP() {
        return this.hostIP;
    }

    @Generated
    public String getOption60() {
        return this.option60;
    }

    @Generated
    public String getOption66() {
        return this.option66;
    }

    @Generated
    public String getOption138() {
        return this.option138;
    }

    @Generated
    public String getDhcpNextServer() {
        return this.dhcpNextServer;
    }

    @Generated
    public List<DhcpOptionOpenApiVO> getOptions() {
        return this.options;
    }

    @Generated
    public DhcpSettingsOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setIpaddrStart(String ipaddrStart) {
        this.ipaddrStart = ipaddrStart;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setIpaddrEnd(String ipaddrEnd) {
        this.ipaddrEnd = ipaddrEnd;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setIpRangeStart(Long ipRangeStart) {
        this.ipRangeStart = ipRangeStart;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setIpRangeEnd(Long ipRangeEnd) {
        this.ipRangeEnd = ipRangeEnd;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setDhcpns(String dhcpns) {
        this.dhcpns = dhcpns;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setPriDns(String priDns) {
        this.priDns = priDns;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setSndDns(String sndDns) {
        this.sndDns = sndDns;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setLeasetime(Integer leasetime) {
        this.leasetime = leasetime;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setHostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setOption60(String option60) {
        this.option60 = option60;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setOption66(String option66) {
        this.option66 = option66;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setOption138(String option138) {
        this.option138 = option138;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setDhcpNextServer(String dhcpNextServer) {
        this.dhcpNextServer = dhcpNextServer;
        return this;
    }

    @Generated
    public DhcpSettingsOpenApiVO setOptions(List<DhcpOptionOpenApiVO> options) {
        this.options = options;
        return this;
    }

    @Generated
    public String toString() {
        return "DhcpSettingsOpenApiVO(enable=" + this.getEnable() + ", ipaddrStart=" + this.getIpaddrStart() + ", ipaddrEnd=" + this.getIpaddrEnd() + ", ipRangeStart=" + this.getIpRangeStart() + ", ipRangeEnd=" + this.getIpRangeEnd() + ", dhcpns=" + this.getDhcpns() + ", priDns=" + this.getPriDns() + ", sndDns=" + this.getSndDns() + ", leasetime=" + this.getLeasetime() + ", gateway=" + this.getGateway() + ", hostIP=" + this.getHostIP() + ", option60=" + this.getOption60() + ", option66=" + this.getOption66() + ", option138=" + this.getOption138() + ", dhcpNextServer=" + this.getDhcpNextServer() + ", options=" + this.getOptions() + ")";
    }
}

