/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.CheckOsgWanStatusOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.CheckWanLanStatusVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.OsgWanStatusVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class CheckWanLanStatusOpenApiVO {
    @Schema(name="portName", description="The map of port name, key: \"port ID\", value: \"port name\"")
    private Map<String, String> portName;
    @Schema(name="networkComptent", description="NetworkComptent")
    private Integer networkComptent;
    @Schema(name="adoptedGateway", description="Indicates whether the gateway is connected")
    private Boolean adoptedGateway;
    @Schema(name="supportIpv6", description="IIndicates whether the gateway support IPv6")
    private Integer supportIpv6;
    @Schema(name="wanList", description="The WAN list of gateway")
    private List<CheckOsgWanStatusOpenApiVO> wanList;
    @Schema(name="iptvPorts", description="IPTVPorts")
    private List<String> iptvPorts;
    @Schema(name="preOsgModel", description="PreOSGModel")
    private Integer preOsgModel;
    @Schema(name="model", description="Model of device,for example:EAP225")
    private String model;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="hasGateway", description="Whether adopt a gateway or enable WAN Settings Overrides.")
    private Boolean hasGateway;

    public static CheckWanLanStatusOpenApiVO buildByWebVO(CheckWanLanStatusVO checkWanLanStatusVO) {
        if (Objects.isNull(checkWanLanStatusVO)) {
            return null;
        }
        CheckWanLanStatusOpenApiVO checkWanLanStatusOpenApiVO = new CheckWanLanStatusOpenApiVO();
        checkWanLanStatusOpenApiVO.setPortName(checkWanLanStatusVO.getPortName());
        checkWanLanStatusOpenApiVO.setNetworkComptent(checkWanLanStatusVO.getNetworkComptent());
        checkWanLanStatusOpenApiVO.setAdoptedGateway(checkWanLanStatusVO.getAdoptedGateway());
        checkWanLanStatusOpenApiVO.setSupportIpv6(checkWanLanStatusVO.getSupportIpv6());
        checkWanLanStatusOpenApiVO.setWanList(CheckWanLanStatusOpenApiVO.buildWanList(checkWanLanStatusVO.getWanList()));
        checkWanLanStatusOpenApiVO.setIptvPorts(checkWanLanStatusVO.getIptvPorts());
        checkWanLanStatusOpenApiVO.setPreOsgModel(checkWanLanStatusVO.getPreOsgModel());
        checkWanLanStatusOpenApiVO.setModel(checkWanLanStatusVO.getModel());
        checkWanLanStatusOpenApiVO.setModelVersion(checkWanLanStatusVO.getModelVersion());
        checkWanLanStatusOpenApiVO.setHasGateway(checkWanLanStatusVO.getHasGateway());
        return checkWanLanStatusOpenApiVO;
    }

    private static List<CheckOsgWanStatusOpenApiVO> buildWanList(List<OsgWanStatusVO> wanList) {
        if (Objects.isNull(wanList)) {
            return null;
        }
        ArrayList<CheckOsgWanStatusOpenApiVO> checkOsgWanStatusOpenApiVOList = new ArrayList<CheckOsgWanStatusOpenApiVO>();
        wanList.forEach(osgWanStatusVO -> {
            CheckOsgWanStatusOpenApiVO openApiVO = new CheckOsgWanStatusOpenApiVO();
            openApiVO.setEnable(osgWanStatusVO.getEnable());
            openApiVO.setNetworkId(osgWanStatusVO.getLanId());
            openApiVO.setPdEnable(osgWanStatusVO.getPdEnable());
            openApiVO.setPdSize(osgWanStatusVO.getPdSize());
            openApiVO.setPortName(osgWanStatusVO.getPortName());
            openApiVO.setPortId(osgWanStatusVO.getPortUuid());
            openApiVO.setPrefix(osgWanStatusVO.getPrefix());
            openApiVO.setProto(CheckWanLanStatusOpenApiVO.buildProto(osgWanStatusVO.getProto()));
            checkOsgWanStatusOpenApiVOList.add(openApiVO);
        });
        return checkOsgWanStatusOpenApiVOList;
    }

    private static Integer buildProto(String proto) {
        if (Objects.isNull(proto)) {
            return null;
        }
        switch (proto) {
            case "static": {
                return 0;
            }
            case "dynamic": {
                return 1;
            }
            case "pppoe": {
                return 2;
            }
            case "6to4Tunnel": {
                return 3;
            }
            case "bridge": {
                return 4;
            }
        }
        return null;
    }

    @Generated
    public Map<String, String> getPortName() {
        return this.portName;
    }

    @Generated
    public Integer getNetworkComptent() {
        return this.networkComptent;
    }

    @Generated
    public Boolean getAdoptedGateway() {
        return this.adoptedGateway;
    }

    @Generated
    public Integer getSupportIpv6() {
        return this.supportIpv6;
    }

    @Generated
    public List<CheckOsgWanStatusOpenApiVO> getWanList() {
        return this.wanList;
    }

    @Generated
    public List<String> getIptvPorts() {
        return this.iptvPorts;
    }

    @Generated
    public Integer getPreOsgModel() {
        return this.preOsgModel;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public Boolean getHasGateway() {
        return this.hasGateway;
    }

    @Generated
    public void setPortName(Map<String, String> portName) {
        this.portName = portName;
    }

    @Generated
    public void setNetworkComptent(Integer networkComptent) {
        this.networkComptent = networkComptent;
    }

    @Generated
    public void setAdoptedGateway(Boolean adoptedGateway) {
        this.adoptedGateway = adoptedGateway;
    }

    @Generated
    public void setSupportIpv6(Integer supportIpv6) {
        this.supportIpv6 = supportIpv6;
    }

    @Generated
    public void setWanList(List<CheckOsgWanStatusOpenApiVO> wanList) {
        this.wanList = wanList;
    }

    @Generated
    public void setIptvPorts(List<String> iptvPorts) {
        this.iptvPorts = iptvPorts;
    }

    @Generated
    public void setPreOsgModel(Integer preOsgModel) {
        this.preOsgModel = preOsgModel;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setHasGateway(Boolean hasGateway) {
        this.hasGateway = hasGateway;
    }

    @Generated
    public String toString() {
        return "CheckWanLanStatusOpenApiVO(portName=" + this.getPortName() + ", networkComptent=" + this.getNetworkComptent() + ", adoptedGateway=" + this.getAdoptedGateway() + ", supportIpv6=" + this.getSupportIpv6() + ", wanList=" + this.getWanList() + ", iptvPorts=" + this.getIptvPorts() + ", preOsgModel=" + this.getPreOsgModel() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", hasGateway=" + this.getHasGateway() + ")";
    }

    @Generated
    public CheckWanLanStatusOpenApiVO(Map<String, String> portName, Integer networkComptent, Boolean adoptedGateway, Integer supportIpv6, List<CheckOsgWanStatusOpenApiVO> wanList, List<String> iptvPorts, Integer preOsgModel, String model, String modelVersion, Boolean hasGateway) {
        this.portName = portName;
        this.networkComptent = networkComptent;
        this.adoptedGateway = adoptedGateway;
        this.supportIpv6 = supportIpv6;
        this.wanList = wanList;
        this.iptvPorts = iptvPorts;
        this.preOsgModel = preOsgModel;
        this.model = model;
        this.modelVersion = modelVersion;
        this.hasGateway = hasGateway;
    }

    @Generated
    public CheckWanLanStatusOpenApiVO() {
    }
}

