/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.BeaconControlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class BeaconControlOpenApiVO {
    @Schema(name="beaconInterval2g", description="2.4GHz beacon interval, parameter beaconInterval2g should be within the range of 40-500)")
    @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval2g] should between 40 and 500")
    private @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval2g] should between 40 and 500") Integer beaconInterval2g;
    @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode2g] should between 0 or 1.")
    @Schema(name="beaconIntvMode2g", description="Configuration for Beacon Interval Mode in the 2G Band:0: Auto 1: Custom")
    private @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode2g] should between 0 or 1.") Integer beaconIntvMode2g;
    @Schema(name="dtimPeriod2g", description="2.4GHz DTIM period, parameter dtimPeriod2g should be within the range of 1-255")
    @NotNull(message="Beacon parameter [dtimPeriod2g] should not be null")
    @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod2g] should between 1 and 255")
    private @NotNull(message="Beacon parameter [dtimPeriod2g] should not be null") @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod2g] should between 1 and 255") Integer dtimPeriod2g;
    @Schema(name="rtsThreshold2g", description="2.4GHz RTS threshold, parameter rtsThreshold2g should be within the range of 1-2347")
    @NotNull(message="Beacon parameter [rtsThreshold2g] should not be null")
    @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold2g] should between 1 and 2347")
    private @NotNull(message="Beacon parameter [rtsThreshold2g] should not be null") @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold2g] should between 1 and 2347") Integer rtsThreshold2g;
    @Schema(name="beaconInterval5g", description="5GHz beacon interval, parameter beaconInterval5g should be within the range of 40-500)")
    @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval5g] should between 40 and 500")
    private @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval5g] should between 40 and 500") Integer beaconInterval5g;
    @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode5g] should between 0 or 1.")
    @Schema(name="beaconIntvMode5g", description="Configuration for Beacon Interval Mode in the 5G Band:0: Auto 1: Custom")
    private @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode5g] should between 0 or 1.") Integer beaconIntvMode5g;
    @Schema(name="dtimPeriod5g", description="5GHz DTIM period, parameter dtimPeriod5g should be within the range of 1-255")
    @NotNull(message="Beacon parameter [dtimPeriod5g] should not be null")
    @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod5g] should between 1 and 255")
    private @NotNull(message="Beacon parameter [dtimPeriod5g] should not be null") @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod5g] should between 1 and 255") Integer dtimPeriod5g;
    @Schema(name="rtsThreshold5g", description="5GHz RTS threshold, parameter rtsThreshold5g should be within the range of 1-2347")
    @NotNull(message="Beacon parameter [rtsThreshold5g] should not be null")
    @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold5g] should between 1 and 2347")
    private @NotNull(message="Beacon parameter [rtsThreshold5g] should not be null") @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold5g] should between 1 and 2347") Integer rtsThreshold5g;
    @Schema(name="beaconInterval6g", description="6GHz beacon interval, parameter beaconInterval6g should be within the range of 40-500)")
    @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval6g] should between 40 and 500")
    private @Range(min=40L, max=500L, message="BeaconControl parameter [beaconInterval6g] should between 40 and 500") Integer beaconInterval6g;
    @Schema(name="beaconIntvMode6g", description="6g band Beacon Interval mode: 0-auto, 1-custom")
    @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode6g] should between 0 or 1.")
    private @Range(min=0L, max=1L, message="BeaconControl parameter [beaconIntvMode6g] should between 0 or 1.") Integer beaconIntvMode6g;
    @Schema(name="dtimPeriod6g", description="6GHz DTIM period, parameter dtimPeriod6g should be within the range of 1-255")
    @NotNull(message="Beacon parameter [dtimPeriod6g] should not be null")
    @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod6g] should between 1 and 255")
    private @NotNull(message="Beacon parameter [dtimPeriod6g] should not be null") @Range(min=1L, max=255L, message="BeaconControl parameter [dtimPeriod6g] should between 1 and 255") Integer dtimPeriod6g;
    @Schema(name="rtsThreshold6g", description="6GHz RTS threshold, parameter rtsThreshold6g should be within the range of 1-2347")
    @NotNull(message="Beacon parameter [rtsThreshold6g] should not be null")
    @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold6g] should between 1 and 2347")
    private @NotNull(message="Beacon parameter [rtsThreshold6g] should not be null") @Range(min=1L, max=2347L, message="BeaconControl parameter [rtsThreshold6g] should between 1 and 2347") Integer rtsThreshold6g;

    public static BeaconControlVO toWebVO(BeaconControlOpenApiVO vo) {
        if (vo == null) {
            return null;
        }
        BeaconControlVO beaconControlVO = new BeaconControlVO();
        beaconControlVO.setBeaconInterval2g(vo.getBeaconInterval2g());
        beaconControlVO.setBeaconIntvMode2g(vo.getBeaconIntvMode2g());
        beaconControlVO.setDtimPeriod2g(vo.getDtimPeriod2g());
        beaconControlVO.setRtsThreshold2g(vo.getRtsThreshold2g());
        beaconControlVO.setBeaconInterval5g(vo.getBeaconInterval5g());
        beaconControlVO.setBeaconIntvMode5g(vo.getBeaconIntvMode5g());
        beaconControlVO.setDtimPeriod5g(vo.getDtimPeriod5g());
        beaconControlVO.setRtsThreshold5g(vo.getRtsThreshold5g());
        beaconControlVO.setBeaconInterval6g(vo.getBeaconInterval6g());
        beaconControlVO.setBeaconIntvMode6g(vo.getBeaconIntvMode6g());
        beaconControlVO.setDtimPeriod6g(vo.getDtimPeriod6g());
        beaconControlVO.setRtsThreshold6g(vo.getRtsThreshold6g());
        return beaconControlVO;
    }

    public static BeaconControlOpenApiVO fromWebVO(BeaconControlVO vo) {
        if (vo == null) {
            return null;
        }
        BeaconControlOpenApiVO beaconControlVO = new BeaconControlOpenApiVO();
        beaconControlVO.setBeaconInterval2g(vo.getBeaconInterval2g());
        beaconControlVO.setBeaconIntvMode2g(vo.getBeaconIntvMode2g());
        beaconControlVO.setDtimPeriod2g(vo.getDtimPeriod2g());
        beaconControlVO.setRtsThreshold2g(vo.getRtsThreshold2g());
        beaconControlVO.setBeaconInterval5g(vo.getBeaconInterval5g());
        beaconControlVO.setBeaconIntvMode5g(vo.getBeaconIntvMode5g());
        beaconControlVO.setDtimPeriod5g(vo.getDtimPeriod5g());
        beaconControlVO.setRtsThreshold5g(vo.getRtsThreshold5g());
        beaconControlVO.setBeaconInterval6g(vo.getBeaconInterval6g());
        beaconControlVO.setBeaconIntvMode6g(vo.getBeaconIntvMode6g());
        beaconControlVO.setDtimPeriod6g(vo.getDtimPeriod6g());
        beaconControlVO.setRtsThreshold6g(vo.getRtsThreshold6g());
        return beaconControlVO;
    }

    @Generated
    public Integer getBeaconInterval2g() {
        return this.beaconInterval2g;
    }

    @Generated
    public Integer getBeaconIntvMode2g() {
        return this.beaconIntvMode2g;
    }

    @Generated
    public Integer getDtimPeriod2g() {
        return this.dtimPeriod2g;
    }

    @Generated
    public Integer getRtsThreshold2g() {
        return this.rtsThreshold2g;
    }

    @Generated
    public Integer getBeaconInterval5g() {
        return this.beaconInterval5g;
    }

    @Generated
    public Integer getBeaconIntvMode5g() {
        return this.beaconIntvMode5g;
    }

    @Generated
    public Integer getDtimPeriod5g() {
        return this.dtimPeriod5g;
    }

    @Generated
    public Integer getRtsThreshold5g() {
        return this.rtsThreshold5g;
    }

    @Generated
    public Integer getBeaconInterval6g() {
        return this.beaconInterval6g;
    }

    @Generated
    public Integer getBeaconIntvMode6g() {
        return this.beaconIntvMode6g;
    }

    @Generated
    public Integer getDtimPeriod6g() {
        return this.dtimPeriod6g;
    }

    @Generated
    public Integer getRtsThreshold6g() {
        return this.rtsThreshold6g;
    }

    @Generated
    public void setBeaconInterval2g(Integer beaconInterval2g) {
        this.beaconInterval2g = beaconInterval2g;
    }

    @Generated
    public void setBeaconIntvMode2g(Integer beaconIntvMode2g) {
        this.beaconIntvMode2g = beaconIntvMode2g;
    }

    @Generated
    public void setDtimPeriod2g(Integer dtimPeriod2g) {
        this.dtimPeriod2g = dtimPeriod2g;
    }

    @Generated
    public void setRtsThreshold2g(Integer rtsThreshold2g) {
        this.rtsThreshold2g = rtsThreshold2g;
    }

    @Generated
    public void setBeaconInterval5g(Integer beaconInterval5g) {
        this.beaconInterval5g = beaconInterval5g;
    }

    @Generated
    public void setBeaconIntvMode5g(Integer beaconIntvMode5g) {
        this.beaconIntvMode5g = beaconIntvMode5g;
    }

    @Generated
    public void setDtimPeriod5g(Integer dtimPeriod5g) {
        this.dtimPeriod5g = dtimPeriod5g;
    }

    @Generated
    public void setRtsThreshold5g(Integer rtsThreshold5g) {
        this.rtsThreshold5g = rtsThreshold5g;
    }

    @Generated
    public void setBeaconInterval6g(Integer beaconInterval6g) {
        this.beaconInterval6g = beaconInterval6g;
    }

    @Generated
    public void setBeaconIntvMode6g(Integer beaconIntvMode6g) {
        this.beaconIntvMode6g = beaconIntvMode6g;
    }

    @Generated
    public void setDtimPeriod6g(Integer dtimPeriod6g) {
        this.dtimPeriod6g = dtimPeriod6g;
    }

    @Generated
    public void setRtsThreshold6g(Integer rtsThreshold6g) {
        this.rtsThreshold6g = rtsThreshold6g;
    }

    @Generated
    public String toString() {
        return "BeaconControlOpenApiVO(beaconInterval2g=" + this.getBeaconInterval2g() + ", beaconIntvMode2g=" + this.getBeaconIntvMode2g() + ", dtimPeriod2g=" + this.getDtimPeriod2g() + ", rtsThreshold2g=" + this.getRtsThreshold2g() + ", beaconInterval5g=" + this.getBeaconInterval5g() + ", beaconIntvMode5g=" + this.getBeaconIntvMode5g() + ", dtimPeriod5g=" + this.getDtimPeriod5g() + ", rtsThreshold5g=" + this.getRtsThreshold5g() + ", beaconInterval6g=" + this.getBeaconInterval6g() + ", beaconIntvMode6g=" + this.getBeaconIntvMode6g() + ", dtimPeriod6g=" + this.getDtimPeriod6g() + ", rtsThreshold6g=" + this.getRtsThreshold6g() + ")";
    }
}

