/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@Schema(name="PSK", description="Auto Created PSKs.")
public class AutoCreatePSKOpenApiVO {
    @Schema(name="name", description="PSK Name")
    @NotNull(message="PSK name should not be null")
    @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,63}$", message="PSK should be 1~64 visible ASCII characters.")
    private @NotNull(message="PSK name should not be null") @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,63}$", message="PSK should be 1~64 visible ASCII characters.") String name;
    @Schema(name="psk", description="Password")
    @NotNull(message="PSK should not be null")
    @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{8,63}|[0-9a-fA-F]{8,63})$", message="PSK should be 8~63 visible ASCII characters.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @NotNull(message="PSK should not be null") @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{8,63}|[0-9a-fA-F]{8,63})$", message="PSK should be 8~63 visible ASCII characters.") String psk;
    @Schema(name="vlan", description="Vlan Bound With PSK")
    @Nullable
    @Max(value=4094L)
    @Min(value=1L)
    private @Max(value=4094L) @Min(value=1L) Integer vlan;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPsk() {
        return this.psk;
    }

    @Nullable
    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public AutoCreatePSKOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public AutoCreatePSKOpenApiVO setPsk(String psk) {
        this.psk = psk;
        return this;
    }

    @Generated
    public AutoCreatePSKOpenApiVO setVlan(@Nullable Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    @Generated
    public String toString() {
        return "AutoCreatePSKOpenApiVO(name=" + this.getName() + ", psk=" + this.getPsk() + ", vlan=" + this.getVlan() + ")";
    }

    @Generated
    public AutoCreatePSKOpenApiVO() {
    }

    @Generated
    public AutoCreatePSKOpenApiVO(String name, String psk, @Nullable Integer vlan) {
        this.name = name;
        this.psk = psk;
        this.vlan = vlan;
    }
}

