/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity;

import com.tplink.smb.omada.manager.configuration.api.openapi.msp.vo.embed.ModifyDstDTO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.NtpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.a.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="UpdateSiteEntity")
public class UpdateSiteEntityOpenApiVO {
    @Schema(name="name", description="Site name should contain 1 to 64 characters.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Schema(name="region", description="Country/Region of the site; For the values of region, refer to the abbreviation of the ISO country code; For example, you need to input \"United States\" for the United States of America.")
    @NotNull(message="Parameter [region] is null")
    private @NotNull(message="Parameter [region] is null") String region;
    @Schema(name="timeZone", description="For the values of the timezone of the site, refer to section 5.1 of the Open API Access Guide.")
    @NotNull(message="Parameter [timeZone] is null")
    private @NotNull(message="Parameter [timeZone] is null") String timeZone;
    @Schema(name="tagIds", description="Site tag ID, Site tag ID can be created using \"Create new site tag\" interface, and site tag ID can be obtained from \"Get site tag list\" interface")
    private Set<String> tagIds;
    @Schema(name="ntpEnable", description="NTP server status of the site")
    private Boolean ntpEnable;
    @Valid
    @Size(max=5, message="NTP server address quantity must less than five")
    @Schema(name="ntpServers", description="NTP server address; Up to 5 entries are allowed for the NTP server address list.")
    private @Valid @Size(max=5, message="NTP server address quantity must less than five") List<NtpServerOpenApiVO> ntpServers;
    @Schema(name="dst", description="Daylight Saving Time config of the site")
    @Valid
    private ModifyDstDTO dst;
    @Schema(name="scenario", description="For the values of the scenario of the site, refer to result of the interface for Get scenario list.")
    @NotNull(message="Parameter [scenario] is null")
    private @NotNull(message="Parameter [scenario] is null") String scenario;
    @Schema(name="longitude", description="Longitude of the site should be within the range of -180 - 180.")
    @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class})
    @Nullable
    private @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class}) Double longitude;
    @Schema(name="latitude", description="Latitude of the site should be within the range of -90 - 90.")
    @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class})
    @Nullable
    private @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class}) Double latitude;
    @Schema(name="address", description="Address of the site")
    @Nullable
    private String address;
    @Schema(name="supportES", description="Whether the site supports adopting Agile Series Switches")
    private Boolean supportES;
    @Schema(name="supportL2", description="Whether the site supports adopting Non-Agile Series Switches")
    private Boolean supportL2;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Boolean getNtpEnable() {
        return this.ntpEnable;
    }

    @Generated
    public List<NtpServerOpenApiVO> getNtpServers() {
        return this.ntpServers;
    }

    @Generated
    public ModifyDstDTO getDst() {
        return this.dst;
    }

    @Generated
    public String getScenario() {
        return this.scenario;
    }

    @Nullable
    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Nullable
    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Nullable
    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public Boolean getSupportES() {
        return this.supportES;
    }

    @Generated
    public Boolean getSupportL2() {
        return this.supportL2;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setNtpEnable(Boolean ntpEnable) {
        this.ntpEnable = ntpEnable;
    }

    @Generated
    public void setNtpServers(List<NtpServerOpenApiVO> ntpServers) {
        this.ntpServers = ntpServers;
    }

    @Generated
    public void setDst(ModifyDstDTO dst) {
        this.dst = dst;
    }

    @Generated
    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    @Generated
    public void setLongitude(@Nullable Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setLatitude(@Nullable Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    @Generated
    public void setSupportES(Boolean supportES) {
        this.supportES = supportES;
    }

    @Generated
    public void setSupportL2(Boolean supportL2) {
        this.supportL2 = supportL2;
    }

    @Generated
    public String toString() {
        return "UpdateSiteEntityOpenApiVO(name=" + this.getName() + ", region=" + this.getRegion() + ", timeZone=" + this.getTimeZone() + ", tagIds=" + this.getTagIds() + ", ntpEnable=" + this.getNtpEnable() + ", ntpServers=" + this.getNtpServers() + ", dst=" + this.getDst() + ", scenario=" + this.getScenario() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", address=" + this.getAddress() + ", supportES=" + this.getSupportES() + ", supportL2=" + this.getSupportL2() + ")";
    }
}

