/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DeviceAccountSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.a.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="CreateSiteEntity")
public class CreateSiteEntityOpenApiVO {
    @Schema(name="name", description="Name of the site should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] should not be null")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @NotNull(message="Parameter [name] should not be null") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Schema(name="type", description="Type of the site should be 0 or 1, and 0 means basic site, 1 means pro site.")
    @Range(min=0L, max=1L, message="Type should be 0 or 1, 0 means basic site, 1 means pro site.")
    private @Range(min=0L, max=1L, message="Type should be 0 or 1, 0 means basic site, 1 means pro site.") Integer type;
    @Schema(name="region", description="Country/Region of the site; For the values of region, refer to the abbreviation of the ISO country code; For example, you need to input \"United States\" for the United States of America.")
    @NotNull(message="Parameter [region] should not be null")
    private @NotNull(message="Parameter [region] should not be null") String region;
    @Schema(name="timeZone", description="For the values of the timezone of the site, refer to section 5.1 of the Open API Access Guide.")
    @NotNull(message="Parameter [timeZone] should not be null")
    private @NotNull(message="Parameter [timeZone] should not be null") String timeZone;
    @Schema(name="scenario", description="For the values of the scenario of the site, refer to result of the interface for Get scenario list.")
    @NotNull(message="Parameter [scenario] should not be null")
    private @NotNull(message="Parameter [scenario] should not be null") String scenario;
    @Schema(name="tagIds", description="Site tag ID, Site tag ID can be created using \"Create new site tag\" interface, and site tag ID can be obtained from \"Get site tag list\" interface")
    private Set<String> tagIds;
    @Schema(name="longitude", description="Longitude of the site should be within the range of -180 - 180.")
    @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class})
    @Nullable
    private @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class}) Double longitude;
    @Schema(name="latitude", description="Latitude of the site should be within the range of -90 - 90.")
    @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class})
    @Nullable
    private @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class}) Double latitude;
    @Schema(name="address", description="Address of the site")
    private String address;
    @Schema(name="deviceAccountSetting", description="Device Account settings")
    @NotNull(message="Parameter [deviceAccountSetting] should not be null")
    @Valid
    private @NotNull(message="Parameter [deviceAccountSetting] should not be null") @Valid DeviceAccountSettingOpenApiVO deviceAccountSetting;
    @Schema(name="supportES", description="Whether the site supports adopting Agile Series Switches")
    private Boolean supportES;
    @Schema(name="supportL2", description="Whether the site supports adopting Non-Agile Series Switches")
    private Boolean supportL2;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public String getScenario() {
        return this.scenario;
    }

    @Generated
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    @Nullable
    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Nullable
    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public DeviceAccountSettingOpenApiVO getDeviceAccountSetting() {
        return this.deviceAccountSetting;
    }

    @Generated
    public Boolean getSupportES() {
        return this.supportES;
    }

    @Generated
    public Boolean getSupportL2() {
        return this.supportL2;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    @Generated
    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setLongitude(@Nullable Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setLatitude(@Nullable Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setDeviceAccountSetting(DeviceAccountSettingOpenApiVO deviceAccountSetting) {
        this.deviceAccountSetting = deviceAccountSetting;
    }

    @Generated
    public void setSupportES(Boolean supportES) {
        this.supportES = supportES;
    }

    @Generated
    public void setSupportL2(Boolean supportL2) {
        this.supportL2 = supportL2;
    }

    @Generated
    public String toString() {
        return "CreateSiteEntityOpenApiVO(name=" + this.getName() + ", type=" + this.getType() + ", region=" + this.getRegion() + ", timeZone=" + this.getTimeZone() + ", scenario=" + this.getScenario() + ", tagIds=" + this.getTagIds() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", address=" + this.getAddress() + ", deviceAccountSetting=" + this.getDeviceAccountSetting() + ", supportES=" + this.getSupportES() + ", supportL2=" + this.getSupportL2() + ")";
    }
}

