/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.ApMdnsRuleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.OsgMdnsRuleTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.mdns.MdnsRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdnsRuleTemplateOpenApiVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MdnsRuleTemplateOpenApiVO.class);
    @Schema(name="id", description="MDNS rule ID")
    private String id;
    @Schema(name="name", description="MDNS rule name")
    private String name;
    @Schema(name="status", description="MDNS rule enable status")
    private Boolean status;
    @Schema(name="profileIds", description="ID list of selected Bonjour Service Profile")
    private List<String> profileIds;
    @Schema(name="type", description="MDNS rule type, 0: AP, 1: Gateway")
    private Integer type;
    @Schema(name="ap", description="MDNS rule AP config, valid when parameter [type] is 0")
    private ApMdnsRuleOpenApiVO ap;
    @Schema(name="osg", description="MDNS rule gateway config, valid when parameter [type] is 1")
    private OsgMdnsRuleTemplateOpenApiVO osg;

    public static MdnsRuleTemplateOpenApiVO toMdnsRuleTemplateOpenApiVO(MdnsRuleVO vo) {
        MdnsRuleTemplateOpenApiVO openApiVO = new MdnsRuleTemplateOpenApiVO();
        openApiVO.setId(vo.getId());
        openApiVO.setName(vo.getName());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setType(vo.getType());
        if (vo.getType() == 0 && vo.getAp() != null) {
            openApiVO.setProfileIds(vo.getAp().getProfileIds());
            openApiVO.setAp(new ApMdnsRuleOpenApiVO().setServiceVlan(vo.getAp().getServiceVlan()).setClientVlan(vo.getAp().getClientVlan()));
        } else if (vo.getType() == 1 && vo.getOsg() != null) {
            openApiVO.setProfileIds(vo.getOsg().getProfileIds());
            OsgMdnsRuleTemplateOpenApiVO osgMdnsRuleTemplateOpenApiVO = new OsgMdnsRuleTemplateOpenApiVO();
            osgMdnsRuleTemplateOpenApiVO.setServiceNetworks(vo.getOsg().getServiceNetworks());
            osgMdnsRuleTemplateOpenApiVO.setClientNetworks(vo.getOsg().getClientNetworks());
            openApiVO.setOsg(osgMdnsRuleTemplateOpenApiVO);
        } else {
            log.warn("Trans to MdnsRuleTemplateOpenApiVO exception, id:{}", (Object)vo.getId());
        }
        return openApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getProfileIds() {
        return this.profileIds;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public ApMdnsRuleOpenApiVO getAp() {
        return this.ap;
    }

    @Generated
    public OsgMdnsRuleTemplateOpenApiVO getOsg() {
        return this.osg;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setProfileIds(List<String> profileIds) {
        this.profileIds = profileIds;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setAp(ApMdnsRuleOpenApiVO ap) {
        this.ap = ap;
    }

    @Generated
    public void setOsg(OsgMdnsRuleTemplateOpenApiVO osg) {
        this.osg = osg;
    }

    @Generated
    public String toString() {
        return "MdnsRuleTemplateOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", profileIds=" + this.getProfileIds() + ", type=" + this.getType() + ", ap=" + this.getAp() + ", osg=" + this.getOsg() + ")";
    }

    @Generated
    public MdnsRuleTemplateOpenApiVO(String id, String name, Boolean status, List<String> profileIds, Integer type, ApMdnsRuleOpenApiVO ap, OsgMdnsRuleTemplateOpenApiVO osg) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.profileIds = profileIds;
        this.type = type;
        this.ap = ap;
        this.osg = osg;
    }

    @Generated
    public MdnsRuleTemplateOpenApiVO() {
    }
}

