/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.ApMdnsRuleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.OsgMdnsRuleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.mdns.ApMdnsRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.mdns.MdnsRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.mdns.OsgMdnsRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class CreateMdnsRuleOpenApiVO {
    @Length(min=1, max=64, message="Name should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] should not be null")
    @Schema(name="name", description="MDNS rule name. Name should contain 1 to 64 characters")
    private @Length(min=1, max=64, message="Name should contain 1 to 64 characters.") @NotNull(message="Parameter [name] should not be null") String name;
    @NotNull(message="Parameter [status] should not be null")
    @Schema(name="status", description="MDNS rule enable status")
    private @NotNull(message="Parameter [status] should not be null") Boolean status;
    @NotNull(message="Parameter [profileIds] should not be null.")
    @Schema(name="profileIds", description="This field represents Bonjour service profile ID. Bonjour Service Profile can be created using 'Create new Bonjour Service' interface, and Bonjour service profile ID can be obtained from 'Get Bonjour Service list' interface")
    private @NotNull(message="Parameter [profileIds] should not be null.") List<String> profileIds;
    @NumberSet(value={0, 1}, message="Parameter [type] should be 0 or 1")
    @Schema(name="type", description="MDNS rule type. Type should be a value as follows: 0: AP, 1: Gateway")
    private Integer type;
    @Valid
    @Schema(name="ap", description="MDNS rule AP config, valid when parameter [type] is 0")
    private ApMdnsRuleOpenApiVO ap;
    @Valid
    @Schema(name="osg", description="MDNS rule gateway config, valid when parameter [type] is 1")
    private OsgMdnsRuleOpenApiVO osg;

    public OperationResponse check() {
        if (this.profileIds.isEmpty()) {
            return new OperationResponse(b.d, "Parameter [profileIds] should not be empty.", null);
        }
        if (this.type == null) {
            return new OperationResponse(b.d, "Parameter [type] should not be null.", null);
        }
        if (this.name == null || this.status == null) {
            return new OperationResponse(b.d);
        }
        if (this.type == 0 && this.ap == null) {
            return new OperationResponse(b.d, "Parameter [ap] should not be null.", null);
        }
        if (this.type == 1 && this.osg == null) {
            return new OperationResponse(b.d, "Parameter [osg] should not be null.", null);
        }
        if (this.type == 1) {
            return this.osg.check();
        }
        return OperationResponse.SUCCESS;
    }

    public MdnsRuleVO toMdnsRuleVO() {
        MdnsRuleVO vo = MdnsRuleVO.builder().name(this.name).status(this.status).type(this.type).build();
        if (this.type == 0) {
            vo.setAp(ApMdnsRuleVO.builder().profileIds(this.profileIds).serviceVlan(this.ap.getServiceVlan()).clientVlan(this.ap.getClientVlan()).build());
        } else {
            vo.setOsg(OsgMdnsRuleVO.builder().profileIds(this.profileIds).serviceNetworks(this.osg.getServiceNetworks()).clientNetworks(this.osg.getClientNetworks()).build());
        }
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getProfileIds() {
        return this.profileIds;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public ApMdnsRuleOpenApiVO getAp() {
        return this.ap;
    }

    @Generated
    public OsgMdnsRuleOpenApiVO getOsg() {
        return this.osg;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setProfileIds(List<String> profileIds) {
        this.profileIds = profileIds;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setAp(ApMdnsRuleOpenApiVO ap) {
        this.ap = ap;
    }

    @Generated
    public void setOsg(OsgMdnsRuleOpenApiVO osg) {
        this.osg = osg;
    }

    @Generated
    public String toString() {
        return "CreateMdnsRuleOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", profileIds=" + this.getProfileIds() + ", type=" + this.getType() + ", ap=" + this.getAp() + ", osg=" + this.getOsg() + ")";
    }

    @Generated
    public CreateMdnsRuleOpenApiVO(String name, Boolean status, List<String> profileIds, Integer type, ApMdnsRuleOpenApiVO ap, OsgMdnsRuleOpenApiVO osg) {
        this.name = name;
        this.status = status;
        this.profileIds = profileIds;
        this.type = type;
        this.ap = ap;
        this.osg = osg;
    }

    @Generated
    public CreateMdnsRuleOpenApiVO() {
    }
}

