/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvCustomOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvDslOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.embed.IptvVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class IptvOpenApiVO {
    @NotNull(message="Param [enable] should not be null.")
    @Schema(name="enable", description="Whether to enable iptv feature. Options: 'true' or 'false'.")
    private @NotNull(message="Param [enable] should not be null.") Boolean enable;
    @NotNull
    @Schema(name="wanPortId", description="WAN port ID can be obtained from 'Get internet basic info' interface.")
    private String wanPortId;
    @NotNull(message="Param [mode] should not be null.")
    @Schema(name="mode", description="Mode should be a value as follows: 0:Bridge, 1:Custom")
    @NumberSet(value={0, 1}, message="Param [mode] should be a Integer in 0 or 1.")
    private @NotNull(message="Param [mode] should not be null.") Integer mode;
    @Schema(name="customConfig", description="Required when parameter[mode] is 1")
    private IptvCustomOpenApiVO customConfig;
    @NotNull(message="Param [portConfig] should not be null.")
    @Schema(name="portConfig", description="Config the port mode of the LAN ports to determine which port is used to support Internet service, IPTV service, or IP Phone service.")
    private @NotNull(message="Param [portConfig] should not be null.") List<IptvPortOpenApiVO> portConfig;
    @Schema(name="dslConfig", description="Configurations that appear only when DSL WAN port is selected.")
    private IptvDslOpenApiVO dslConfig;

    public static IptvOpenApiVO fromWeb(IptvVO vo) {
        IptvOpenApiVO res = new IptvOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setEnable(vo.getIptvEnable());
        res.setWanPortId(vo.getWanPortId());
        res.setMode(vo.getMode());
        res.setCustomConfig(IptvCustomOpenApiVO.fromWeb(vo.getCustomConfig()));
        res.setPortConfig(CollectionUtils.isEmpty((Collection)vo.getPortConfig()) ? new ArrayList<IptvPortOpenApiVO>() : vo.getPortConfig().stream().map(IptvPortOpenApiVO::fromWeb).collect(Collectors.toList()));
        res.setDslConfig(IptvDslOpenApiVO.fromWeb(vo.getDslConfig()));
        return res;
    }

    public static IptvVO toWeb(IptvOpenApiVO vo) {
        IptvVO res = new IptvVO();
        if (vo == null) {
            return res;
        }
        res.setIptvEnable(vo.getEnable());
        res.setWanPortId(vo.getWanPortId());
        res.setMode(vo.getMode());
        res.setCustomConfig(IptvCustomOpenApiVO.toWeb(vo.getCustomConfig()));
        res.setPortConfig(vo.getPortConfig().isEmpty() ? new ArrayList() : vo.getPortConfig().stream().map(IptvPortOpenApiVO::toWeb).collect(Collectors.toList()));
        res.setDslConfig(IptvDslOpenApiVO.toWeb(vo.getDslConfig()));
        return res;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getWanPortId() {
        return this.wanPortId;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public IptvCustomOpenApiVO getCustomConfig() {
        return this.customConfig;
    }

    @Generated
    public List<IptvPortOpenApiVO> getPortConfig() {
        return this.portConfig;
    }

    @Generated
    public IptvDslOpenApiVO getDslConfig() {
        return this.dslConfig;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setWanPortId(String wanPortId) {
        this.wanPortId = wanPortId;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setCustomConfig(IptvCustomOpenApiVO customConfig) {
        this.customConfig = customConfig;
    }

    @Generated
    public void setPortConfig(List<IptvPortOpenApiVO> portConfig) {
        this.portConfig = portConfig;
    }

    @Generated
    public void setDslConfig(IptvDslOpenApiVO dslConfig) {
        this.dslConfig = dslConfig;
    }

    @Generated
    public IptvOpenApiVO(Boolean enable, String wanPortId, Integer mode, IptvCustomOpenApiVO customConfig, List<IptvPortOpenApiVO> portConfig, IptvDslOpenApiVO dslConfig) {
        this.enable = enable;
        this.wanPortId = wanPortId;
        this.mode = mode;
        this.customConfig = customConfig;
        this.portConfig = portConfig;
        this.dslConfig = dslConfig;
    }

    @Generated
    public IptvOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "IptvOpenApiVO(enable=" + this.getEnable() + ", wanPortId=" + this.getWanPortId() + ", mode=" + this.getMode() + ", customConfig=" + this.getCustomConfig() + ", portConfig=" + this.getPortConfig() + ", dslConfig=" + this.getDslConfig() + ")";
    }
}

