/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.embed.IgmpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

public class IgmpOpenApiVO {
    @NotNull(message="Param [enable] should not be null.")
    @Schema(name="enable")
    private @NotNull(message="Param [enable] should not be null.") Boolean enable;
    @NotNull(message="Param [version] should not be null.")
    @Schema(name="version", description="Version should be a value as follows: 2:v2; 3:v3.")
    @NumberSet(value={2, 3}, message="Param [version] should be a Integer in 2 or 3.")
    private @NotNull(message="Param [version] should not be null.") Integer version;
    @Schema(name="wanPortId", description="WAN port ID, can be obtained from 'Get internet basic info' interface. At least one of the wanPortId or virtualWanId should not be null.")
    private String wanPortId;
    @Schema(name="virtualWanId", description="Virtual WAN ID, can be obtained from 'Query virtual WAN list' interface. At least one of the wanPortId or virtualWanId should not be null.")
    private String virtualWanId;

    public static IgmpOpenApiVO fromWeb(IgmpVO vo) {
        IgmpOpenApiVO res = new IgmpOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setEnable(vo.getIgmpProxyEnable());
        res.setVersion(Integer.valueOf(vo.getIgmpVersion()));
        res.setWanPortId(vo.getWanPortId());
        res.setVirtualWanId(vo.getVirtualWanId());
        return res;
    }

    public static IgmpVO toWeb(IgmpOpenApiVO vo) {
        IgmpVO res = new IgmpVO();
        if (vo == null) {
            return res;
        }
        res.setIgmpProxyEnable(vo.getEnable());
        res.setIgmpVersion(String.valueOf(vo.getVersion()));
        res.setWanPortId(vo.getWanPortId());
        res.setVirtualWanId(vo.getVirtualWanId());
        return res;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getWanPortId() {
        return this.wanPortId;
    }

    @Generated
    public String getVirtualWanId() {
        return this.virtualWanId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public void setWanPortId(String wanPortId) {
        this.wanPortId = wanPortId;
    }

    @Generated
    public void setVirtualWanId(String virtualWanId) {
        this.virtualWanId = virtualWanId;
    }

    @Generated
    public IgmpOpenApiVO(Boolean enable, Integer version, String wanPortId, String virtualWanId) {
        this.enable = enable;
        this.version = version;
        this.wanPortId = wanPortId;
        this.virtualWanId = virtualWanId;
    }

    @Generated
    public IgmpOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "IgmpOpenApiVO(enable=" + this.getEnable() + ", version=" + this.getVersion() + ", wanPortId=" + this.getWanPortId() + ", virtualWanId=" + this.getVirtualWanId() + ")";
    }
}

