/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DotCustomizedServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DefaultServerVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DotSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class DotSettingOpenApiVO {
    @NumberSet(value={0, 1, 2, 3, 4}, message="Parameter [defaultServers] is invalid.")
    @Schema(name="defaultServers", description="Preconfigured Server List. DefaultServers should be a value as follows: 0:Google, 1\uff1aCloudflare, 2\uff1aOpenDNS, 3\uff1aQuad9, 4: CleanBrowsing. Up to 2 DoT default and custom servers can be selected. For example, defaultServers : [0, 1] represents that you have selected default services Google and Cloudflare")
    private Set<Integer> defaultServers;
    @Valid
    @Schema(name="customizedServers", description="Custom Service list. Up to 2 DoT default and custom Servers can be selected, setting the parameter [enable] to true indicates the selection of the custom server.")
    private List<DotCustomizedServerOpenApiVO> customizedServers;

    public static DotSettingOpenApiVO toOpenApiVO(DotSettingVO vo) {
        DotSettingOpenApiVO openApiVO = new DotSettingOpenApiVO();
        HashSet<Integer> servers = new HashSet<Integer>(2);
        vo.getDefaultServers().forEach(server -> {
            if (Boolean.TRUE.equals(server.getEnable())) {
                servers.add(server.getType());
            }
        });
        openApiVO.setDefaultServers(servers);
        openApiVO.setCustomizedServers(vo.getCustomizedServers().stream().map(DotCustomizedServerOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiVO;
    }

    public OperationResponse check() {
        int serversNum = 0;
        if (!CollectionUtils.isEmpty(this.defaultServers)) {
            serversNum += this.defaultServers.size();
        }
        if (serversNum > 2) {
            return new OperationResponse(b.d, "Up to 2 DoT DNS default servers can be selected.", null);
        }
        if (!CollectionUtils.isEmpty(this.customizedServers)) {
            for (DotCustomizedServerOpenApiVO customizedServer : this.customizedServers) {
                OperationResponse checkRes = customizedServer.check();
                if (!checkRes.success()) {
                    return checkRes;
                }
                if (!Boolean.TRUE.equals(customizedServer.getEnable())) continue;
                ++serversNum;
            }
            if (serversNum > 2) {
                return new OperationResponse(b.d, "Up to 2 DoT DNS default and custom servers can be selected.", null);
            }
        }
        return OperationResponse.SUCCESS;
    }

    public DotSettingVO toVO() {
        DotSettingVO vo = new DotSettingVO();
        if (!CollectionUtils.isEmpty(this.defaultServers)) {
            ArrayList<DefaultServerVO> defaultServerVOList = new ArrayList<DefaultServerVO>(5);
            Integer[] integerArray = a.i;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int defaultServer = integerArray[j];
                DefaultServerVO defaultServerVO = !CollectionUtils.isEmpty(this.defaultServers) && this.defaultServers.contains(defaultServer) ? DefaultServerVO.builder().enable(Boolean.valueOf(true)).type(Integer.valueOf(defaultServer)).build() : DefaultServerVO.builder().enable(Boolean.valueOf(false)).type(Integer.valueOf(defaultServer)).build();
                defaultServerVOList.add(defaultServerVO);
            }
            vo.setDefaultServers(defaultServerVOList);
        }
        if (!CollectionUtils.isEmpty(this.customizedServers)) {
            vo.setCustomizedServers(this.customizedServers.stream().filter(Objects::nonNull).map(DotCustomizedServerOpenApiVO::toVO).collect(Collectors.toList()));
        }
        return vo;
    }

    @Generated
    public Set<Integer> getDefaultServers() {
        return this.defaultServers;
    }

    @Generated
    public List<DotCustomizedServerOpenApiVO> getCustomizedServers() {
        return this.customizedServers;
    }

    @Generated
    public void setDefaultServers(Set<Integer> defaultServers) {
        this.defaultServers = defaultServers;
    }

    @Generated
    public void setCustomizedServers(List<DotCustomizedServerOpenApiVO> customizedServers) {
        this.customizedServers = customizedServers;
    }

    @Generated
    public String toString() {
        return "DotSettingOpenApiVO(defaultServers=" + this.getDefaultServers() + ", customizedServers=" + this.getCustomizedServers() + ")";
    }

    @Generated
    public DotSettingOpenApiVO(Set<Integer> defaultServers, List<DotCustomizedServerOpenApiVO> customizedServers) {
        this.defaultServers = defaultServers;
        this.customizedServers = customizedServers;
    }

    @Generated
    public DotSettingOpenApiVO() {
    }
}

