/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.f.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.CustomizedServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class DotCustomizedServerOpenApiVO {
    @NotNull(message="Parameter [enable] in customizedServers should not be null.")
    @Schema(name="enable", description="Custom service enable status")
    private @NotNull(message="Parameter [enable] in customizedServers should not be null.") Boolean enable;
    @NotNull(message="Parameter [name] in customizedServers should not be null.")
    @Schema(name="name", description="Custom service name, should contain 1 to 64 characters")
    private @NotNull(message="Parameter [name] in customizedServers should not be null.") String name;
    @NotNull(message="Parameter [servers] in customizedServers should not be null.")
    @Schema(name="servers", description="Custom service IPs, up to 2 IPs can be configured")
    private @NotNull(message="Parameter [servers] in customizedServers should not be null.") List<String> servers;

    public static DotCustomizedServerOpenApiVO toOpenApiVO(CustomizedServerVO vo) {
        DotCustomizedServerOpenApiVO dotCustomizedServerOpenApiVO = new DotCustomizedServerOpenApiVO();
        dotCustomizedServerOpenApiVO.setEnable(vo.getEnable());
        dotCustomizedServerOpenApiVO.setName(vo.getName());
        dotCustomizedServerOpenApiVO.setServers(vo.getServers());
        return dotCustomizedServerOpenApiVO;
    }

    public OperationResponse check() {
        if (CollectionUtils.isEmpty(this.servers)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, "Parameter [servers] in [customizedServers] should not be empty.", null);
        }
        if (this.servers.size() > 2) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, "Up to 2 IPs can be configured in parameter [servers] in [customizedServers].", null);
        }
        for (String ip : this.servers) {
            if (b.c((String)ip)) continue;
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, "Invalid IP address in parameter [servers] in [customizedServers].", null);
        }
        return OperationResponse.SUCCESS;
    }

    public static CustomizedServerVO toVO(DotCustomizedServerOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return CustomizedServerVO.builder().enable(openApiVO.getEnable()).name(openApiVO.getName()).servers(openApiVO.getServers()).build();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getServers() {
        return this.servers;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    @Generated
    public String toString() {
        return "DotCustomizedServerOpenApiVO(enable=" + this.getEnable() + ", name=" + this.getName() + ", servers=" + this.getServers() + ")";
    }

    @Generated
    public DotCustomizedServerOpenApiVO(Boolean enable, String name, List<String> servers) {
        this.enable = enable;
        this.name = name;
        this.servers = servers;
    }

    @Generated
    public DotCustomizedServerOpenApiVO() {
    }
}

