/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DohCustomizedServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DefaultServerVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DohSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class DohSettingOpenApiVO {
    @NumberSet(value={0, 1, 4, 5, 6}, message="Parameter [defaultServers] is invalid.")
    @Schema(name="defaultServers", description="Preconfigured Server List. DefaultServers should be a value as follows: 0:Google, 1\uff1aCloudflare, 4\uff1aCleanBrowsing, 5\uff1aQuad9_1, 6: Quad9_2. Up to 2 DoH default and custom servers can be selected. For example, defaultServers : [0, 1] represents that you have selected default services Google and Cloudflare")
    private Set<Integer> defaultServers;
    @Valid
    @Schema(name="customizedServers", description="Custom Service list. Up to 2 DoH default and custom Servers can be selected, setting the parameter [enable] to true indicates the selection of the custom server.")
    private List<DohCustomizedServerOpenApiVO> customizedServers;

    public static DohSettingOpenApiVO toOpenApiVO(DohSettingVO vo) {
        DohSettingOpenApiVO openApiVO = new DohSettingOpenApiVO();
        HashSet<Integer> servers = new HashSet<Integer>(2);
        vo.getDefaultServers().forEach(server -> {
            if (Boolean.TRUE.equals(server.getEnable())) {
                servers.add(server.getType());
            }
        });
        openApiVO.setDefaultServers(servers);
        openApiVO.setCustomizedServers(vo.getCustomizedServers().stream().map(DohCustomizedServerOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiVO;
    }

    public OperationResponse check() {
        int serversNum = 0;
        if (!CollectionUtils.isEmpty(this.defaultServers)) {
            serversNum += this.defaultServers.size();
        }
        if (serversNum > 2) {
            return new OperationResponse(b.d, "Up to 2 DoH DNS default servers can be selected.", null);
        }
        if (!CollectionUtils.isEmpty(this.customizedServers)) {
            for (DohCustomizedServerOpenApiVO customizedServer : this.customizedServers) {
                if (!Boolean.TRUE.equals(customizedServer.getEnable())) continue;
                ++serversNum;
            }
            if (serversNum > 2) {
                return new OperationResponse(b.d, "Up to 2 DoH DNS default and custom servers can be selected.", null);
            }
        }
        return OperationResponse.SUCCESS;
    }

    public DohSettingVO toVO() {
        DohSettingVO vo = new DohSettingVO();
        if (!CollectionUtils.isEmpty(this.defaultServers)) {
            ArrayList<DefaultServerVO> defaultServerVOList = new ArrayList<DefaultServerVO>(5);
            Integer[] integerArray = a.h;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int defaultServer = integerArray[j];
                DefaultServerVO defaultServerVO = this.defaultServers.contains(defaultServer) ? DefaultServerVO.builder().enable(Boolean.valueOf(true)).type(Integer.valueOf(defaultServer)).build() : DefaultServerVO.builder().enable(Boolean.valueOf(false)).type(Integer.valueOf(defaultServer)).build();
                defaultServerVOList.add(defaultServerVO);
            }
            vo.setDefaultServers(defaultServerVOList);
        }
        if (!CollectionUtils.isEmpty(this.customizedServers)) {
            vo.setCustomizedServers(this.customizedServers.stream().filter(Objects::nonNull).map(DohCustomizedServerOpenApiVO::toVO).collect(Collectors.toList()));
        }
        return vo;
    }

    @Generated
    public Set<Integer> getDefaultServers() {
        return this.defaultServers;
    }

    @Generated
    public List<DohCustomizedServerOpenApiVO> getCustomizedServers() {
        return this.customizedServers;
    }

    @Generated
    public void setDefaultServers(Set<Integer> defaultServers) {
        this.defaultServers = defaultServers;
    }

    @Generated
    public void setCustomizedServers(List<DohCustomizedServerOpenApiVO> customizedServers) {
        this.customizedServers = customizedServers;
    }

    @Generated
    public String toString() {
        return "DohSettingOpenApiVO(defaultServers=" + this.getDefaultServers() + ", customizedServers=" + this.getCustomizedServers() + ")";
    }

    @Generated
    public DohSettingOpenApiVO(Set<Integer> defaultServers, List<DohCustomizedServerOpenApiVO> customizedServers) {
        this.defaultServers = defaultServers;
        this.customizedServers = customizedServers;
    }

    @Generated
    public DohSettingOpenApiVO() {
    }
}

