/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.CustomizedServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collections;
import lombok.Generated;

public class DohCustomizedServerOpenApiVO {
    @NotNull(message="Parameter [enable] in customizedServers should not be null.")
    @Schema(name="enable", description="Custom service enable status")
    private @NotNull(message="Parameter [enable] in customizedServers should not be null.") Boolean enable;
    @NotNull(message="Parameter [name] in customizedServers should not be null.")
    @Schema(name="name", description="Custom service name, should contain 1 to 64 characters")
    private @NotNull(message="Parameter [name] in customizedServers should not be null.") String name;
    @NotNull(message="Parameter [server] in customizedServers should not be null.")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [server] in customizedServers is invalid.")
    @Schema(name="server", description="Custom service IP or domain")
    private @NotNull(message="Parameter [server] in customizedServers should not be null.") @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [server] in customizedServers is invalid.") String server;

    public static DohCustomizedServerOpenApiVO toOpenApiVO(CustomizedServerVO vo) {
        DohCustomizedServerOpenApiVO dohCustomizedServerOpenApiVO = new DohCustomizedServerOpenApiVO();
        dohCustomizedServerOpenApiVO.setEnable(vo.getEnable());
        dohCustomizedServerOpenApiVO.setName(vo.getName());
        dohCustomizedServerOpenApiVO.setServer((String)vo.getServers().get(0));
        return dohCustomizedServerOpenApiVO;
    }

    public static CustomizedServerVO toVO(DohCustomizedServerOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return CustomizedServerVO.builder().enable(openApiVO.getEnable()).name(openApiVO.getName()).servers(Collections.singletonList("https://" + openApiVO.getServer())).build();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public String toString() {
        return "DohCustomizedServerOpenApiVO(enable=" + this.getEnable() + ", name=" + this.getName() + ", server=" + this.getServer() + ")";
    }

    @Generated
    public DohCustomizedServerOpenApiVO(Boolean enable, String name, String server) {
        this.enable = enable;
        this.name = name;
        this.server = server;
    }

    @Generated
    public DohCustomizedServerOpenApiVO() {
    }
}

