/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class DnsSecSettingOpenApiVO {
    @NotNull(message="Parameter [servers] should not be null.")
    @Schema(name="servers", description="DNS Server IP list, Up to 2 entries are allowed for the server list")
    private @NotNull(message="Parameter [servers] should not be null.") List<String> servers;
    @NotNull(message="Parameter [replyPolicy] should not be null.")
    @NumberSet(value={0, 1}, message="Parameter [replyPolicy] should be 0 or 1.")
    @Schema(name="replyPolicy", description="Bogus DNS reply policy type. ReplyPolicy should be a value as follows: 0: Pass, 1: Drop")
    private @NotNull(message="Parameter [replyPolicy] should not be null.") Integer replyPolicy;

    public OperationResponse check() {
        if (CollectionUtils.isEmpty(this.servers)) {
            return new OperationResponse(b.sH);
        }
        for (String ip : this.servers) {
            if (v.h((String)ip)) continue;
            return new OperationResponse(b.d, "Invalid IP address in parameter [servers].", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public List<String> getServers() {
        return this.servers;
    }

    @Generated
    public Integer getReplyPolicy() {
        return this.replyPolicy;
    }

    @Generated
    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    @Generated
    public void setReplyPolicy(Integer replyPolicy) {
        this.replyPolicy = replyPolicy;
    }

    @Generated
    public String toString() {
        return "DnsSecSettingOpenApiVO(servers=" + this.getServers() + ", replyPolicy=" + this.getReplyPolicy() + ")";
    }

    @Generated
    public DnsSecSettingOpenApiVO(List<String> servers, Integer replyPolicy) {
        this.servers = servers;
        this.replyPolicy = replyPolicy;
    }

    @Generated
    public DnsSecSettingOpenApiVO() {
    }
}

