/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsOverrideSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsSecSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DohSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DotSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DnsProxySettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class DnsProxySettingQueryOpenApiVO {
    @Schema(name="enable", description="DNS proxy setting enable status.")
    private Boolean enable;
    @Schema(name="type", description="DNS proxy setting type. Type should be a value as follows: 0: DNSSEC, 1: DoH, 2: DoT, 3: DNS Override")
    private Integer type;
    @Schema(name="dnsSecSetting", description="DNS proxy DNSSEC setting, valid when parameter [type] is 0")
    private DnsSecSettingOpenApiVO dnsSecSetting;
    @Schema(name="dohSetting", description="DNS proxy DoH setting, valid when parameter [type] is 1")
    private DohSettingOpenApiVO dohSetting;
    @Schema(name="dotSetting", description="DNS proxy DoT setting, valid when parameter [type] is 2")
    private DotSettingOpenApiVO dotSetting;
    @Schema(name="dnsOverrideSetting", description="DNS Override setting, valid when parameter [type] is 3")
    private DnsOverrideSettingOpenApiVO dnsOverrideSetting;
    @Schema(name="supportDnsOverride", description="Whether DNS Override setting is supported in DNS Proxy.")
    private Boolean supportDnsOverride;
    @Schema(name="existDnsOverride", description="Whether DNS Override has been configured in DNS Proxy.")
    private Boolean existDnsOverride;

    public static DnsProxySettingQueryOpenApiVO toOpenApiVO(DnsProxySettingVO vo) {
        if (vo == null) {
            return null;
        }
        DnsProxySettingQueryOpenApiVO openApiVO = new DnsProxySettingQueryOpenApiVO();
        openApiVO.setEnable(vo.isEnable());
        openApiVO.setSupportDnsOverride(vo.getSupportDnsOverride());
        openApiVO.setExistDnsOverride(vo.getExistDnsOverride());
        if (vo.getDnsSecSetting() != null) {
            DnsSecSettingOpenApiVO dnsSecSettingOpenApiVO = new DnsSecSettingOpenApiVO();
            dnsSecSettingOpenApiVO.setServers(vo.getDnsSecSetting().getServers());
            dnsSecSettingOpenApiVO.setReplyPolicy(vo.getDnsSecSetting().getReplyPolicy());
            openApiVO.setType(0).setDnsSecSetting(dnsSecSettingOpenApiVO);
            return openApiVO;
        }
        if (vo.getDohSetting() != null) {
            openApiVO.setType(1).setDohSetting(DohSettingOpenApiVO.toOpenApiVO(vo.getDohSetting()));
            return openApiVO;
        }
        if (vo.getDotSetting() != null) {
            openApiVO.setType(2).setDotSetting(DotSettingOpenApiVO.toOpenApiVO(vo.getDotSetting()));
            return openApiVO;
        }
        if (vo.getDnsOverrideSetting() != null) {
            openApiVO.setType(3).setDnsOverrideSetting(DnsOverrideSettingOpenApiVO.toOpenApiVO(vo.getDnsOverrideSetting()));
        }
        return openApiVO;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public DnsSecSettingOpenApiVO getDnsSecSetting() {
        return this.dnsSecSetting;
    }

    @Generated
    public DohSettingOpenApiVO getDohSetting() {
        return this.dohSetting;
    }

    @Generated
    public DotSettingOpenApiVO getDotSetting() {
        return this.dotSetting;
    }

    @Generated
    public DnsOverrideSettingOpenApiVO getDnsOverrideSetting() {
        return this.dnsOverrideSetting;
    }

    @Generated
    public Boolean getSupportDnsOverride() {
        return this.supportDnsOverride;
    }

    @Generated
    public Boolean getExistDnsOverride() {
        return this.existDnsOverride;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setDnsSecSetting(DnsSecSettingOpenApiVO dnsSecSetting) {
        this.dnsSecSetting = dnsSecSetting;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setDohSetting(DohSettingOpenApiVO dohSetting) {
        this.dohSetting = dohSetting;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setDotSetting(DotSettingOpenApiVO dotSetting) {
        this.dotSetting = dotSetting;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setDnsOverrideSetting(DnsOverrideSettingOpenApiVO dnsOverrideSetting) {
        this.dnsOverrideSetting = dnsOverrideSetting;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setSupportDnsOverride(Boolean supportDnsOverride) {
        this.supportDnsOverride = supportDnsOverride;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO setExistDnsOverride(Boolean existDnsOverride) {
        this.existDnsOverride = existDnsOverride;
        return this;
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO() {
    }

    @Generated
    public DnsProxySettingQueryOpenApiVO(Boolean enable, Integer type, DnsSecSettingOpenApiVO dnsSecSetting, DohSettingOpenApiVO dohSetting, DotSettingOpenApiVO dotSetting, DnsOverrideSettingOpenApiVO dnsOverrideSetting, Boolean supportDnsOverride, Boolean existDnsOverride) {
        this.enable = enable;
        this.type = type;
        this.dnsSecSetting = dnsSecSetting;
        this.dohSetting = dohSetting;
        this.dotSetting = dotSetting;
        this.dnsOverrideSetting = dnsOverrideSetting;
        this.supportDnsOverride = supportDnsOverride;
        this.existDnsOverride = existDnsOverride;
    }
}

