/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsOverrideSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsSecSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DohSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DotSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DnsProxySettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnsproxy.DnsSecSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;

public class DnsProxySettingOpenApiVO {
    @NotNull(message="Parameter [enable] should not be null.")
    @Schema(name="enable", description="DNS proxy setting enable status")
    private @NotNull(message="Parameter [enable] should not be null.") Boolean enable;
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [type] should be a Integer in 0, 1, 2 or 3.")
    @Schema(name="type", description="DNS proxy setting type. Type should be a value as follows: 0: DNSSEC, 1: DoH, 2: DoT, 3: DNS Override")
    private Integer type;
    @Valid
    @Schema(name="dnsSecSetting", description="DNS proxy DNSSEC setting, valid when parameter [type] is 0")
    private DnsSecSettingOpenApiVO dnsSecSetting;
    @Valid
    @Schema(name="dohSetting", description="DNS proxy DoH setting, valid when parameter [type] is 1")
    private DohSettingOpenApiVO dohSetting;
    @Valid
    @Schema(name="dotSetting", description="DNS proxy DoT setting, valid when parameter [type] is 2")
    private DotSettingOpenApiVO dotSetting;
    @Valid
    @Schema(name="dnsOverrideSetting", description="DNS Override setting, valid when parameter [type] is 3")
    private DnsOverrideSettingOpenApiVO dnsOverrideSetting;

    public OperationResponse check() {
        if (!Boolean.TRUE.equals(this.enable)) {
            return OperationResponse.SUCCESS;
        }
        if (Objects.isNull(this.type)) {
            return new OperationResponse(b.d, "Parameter [type] should not be null.", null);
        }
        if (this.type == 0 && this.dnsSecSetting == null) {
            return new OperationResponse(b.d, "Parameter [dnsSecSetting] should not be null.", null);
        }
        if (this.type == 0) {
            return this.dnsSecSetting.check();
        }
        if (this.type == 1 && this.dohSetting == null) {
            return new OperationResponse(b.d, "Parameter [dohSetting] should not be null.", null);
        }
        if (this.type == 1) {
            return this.dohSetting.check();
        }
        if (this.type == 2 && this.dotSetting == null) {
            return new OperationResponse(b.d, "Parameter [dotSetting] should not be null.", null);
        }
        if (this.type == 2) {
            return this.dotSetting.check();
        }
        if (this.type == 3 && this.dnsOverrideSetting == null) {
            return new OperationResponse(b.d, "Parameter [dnsOverrideSetting] should not be null.", null);
        }
        return this.dnsOverrideSetting.check();
    }

    public DnsProxySettingVO toVO() {
        DnsProxySettingVO vo = new DnsProxySettingVO();
        vo.setEnable(this.enable.booleanValue());
        if (!Boolean.TRUE.equals(this.enable)) {
            return vo;
        }
        switch (this.type) {
            case 0: {
                vo.setDnsSecSetting(DnsSecSettingVO.builder().servers(this.dnsSecSetting.getServers()).replyPolicy(this.dnsSecSetting.getReplyPolicy()).build());
                return vo;
            }
            case 1: {
                vo.setDohSetting(this.dohSetting.toVO());
                return vo;
            }
            case 2: {
                vo.setDotSetting(this.dotSetting.toVO());
                return vo;
            }
            case 3: {
                vo.setDnsOverrideSetting(this.dnsOverrideSetting.toVO());
                return vo;
            }
        }
        return vo;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public DnsSecSettingOpenApiVO getDnsSecSetting() {
        return this.dnsSecSetting;
    }

    @Generated
    public DohSettingOpenApiVO getDohSetting() {
        return this.dohSetting;
    }

    @Generated
    public DotSettingOpenApiVO getDotSetting() {
        return this.dotSetting;
    }

    @Generated
    public DnsOverrideSettingOpenApiVO getDnsOverrideSetting() {
        return this.dnsOverrideSetting;
    }

    @Generated
    public DnsProxySettingOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public DnsProxySettingOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public DnsProxySettingOpenApiVO setDnsSecSetting(DnsSecSettingOpenApiVO dnsSecSetting) {
        this.dnsSecSetting = dnsSecSetting;
        return this;
    }

    @Generated
    public DnsProxySettingOpenApiVO setDohSetting(DohSettingOpenApiVO dohSetting) {
        this.dohSetting = dohSetting;
        return this;
    }

    @Generated
    public DnsProxySettingOpenApiVO setDotSetting(DotSettingOpenApiVO dotSetting) {
        this.dotSetting = dotSetting;
        return this;
    }

    @Generated
    public DnsProxySettingOpenApiVO setDnsOverrideSetting(DnsOverrideSettingOpenApiVO dnsOverrideSetting) {
        this.dnsOverrideSetting = dnsOverrideSetting;
        return this;
    }

    @Generated
    public String toString() {
        return "DnsProxySettingOpenApiVO(enable=" + this.getEnable() + ", type=" + this.getType() + ", dnsSecSetting=" + this.getDnsSecSetting() + ", dohSetting=" + this.getDohSetting() + ", dotSetting=" + this.getDotSetting() + ", dnsOverrideSetting=" + this.getDnsOverrideSetting() + ")";
    }

    @Generated
    public DnsProxySettingOpenApiVO(Boolean enable, Integer type, DnsSecSettingOpenApiVO dnsSecSetting, DohSettingOpenApiVO dohSetting, DotSettingOpenApiVO dotSetting, DnsOverrideSettingOpenApiVO dnsOverrideSetting) {
        this.enable = enable;
        this.type = type;
        this.dnsSecSetting = dnsSecSetting;
        this.dohSetting = dohSetting;
        this.dotSetting = dotSetting;
        this.dnsOverrideSetting = dnsOverrideSetting;
    }

    @Generated
    public DnsProxySettingOpenApiVO() {
    }
}

