/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.DhcpReservationVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public class DhcpReservationOpenApiVO {
    @Schema(name="id", description="DHCP reservation ID")
    private String id;
    @Schema(name="description", description="Description of DHCP reservation")
    private String description;
    @Schema(name="netId", description="ID of the configured LAN Network")
    private String netId;
    @Schema(name="netName", description="Name of the configured LAN Network")
    private String netName;
    @Schema(name="mac", description="Device MAC address")
    @a
    private String mac;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.")
    @Schema(name="ip", description="Reserved IP address")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.") String ip;
    @Schema(name="options", description="Advanced DHCP options")
    private List<DhcpOptionOpenApiVO> options;
    @Schema(name="status", description="DHCP reservation enable status")
    private Boolean status;
    @Schema(name="exportToIpMacBinding", description="Indicates whether DHCP reservation can be exported to the IP-MAC Binding list")
    private Boolean exportToIpMacBinding;
    @Schema(name="clientName", description="Client name")
    @Deprecated
    private String clientName;
    @Schema(name="name", description="Device Name")
    private String name;
    @Schema(name="existOptions", description="Options configured in the current DHCP Reservation entry.")
    private List<Integer> existOptions;
    @Schema(name="type", description="Type should be a value as follows: 0: Device; 1: Client")
    private Integer type;
    @Schema(name="showingType", description="Client Type or Device Type")
    private String showingType;
    @Schema(name="model", description="Device Model")
    private String model;
    @Schema(name="modelVersion", description="Device Model Version")
    private String modelVersion;
    @Schema(name="serverName", description="Dhcp Server Device Name")
    private String serverName;
    @Schema(name="serverType", description="Dhcp Server Device Type")
    private String serverType;
    @Schema(name="serverMac", description="Dhcp Server Device Mac")
    @a
    private String serverMac;
    @Schema(name="serverStackId", description="Dhcp Server Stack ID")
    private String serverStackId;
    @Schema(name="abnormal", description="Abnormal cause")
    private Integer abnormal;

    public static DhcpReservationOpenApiVO toDhcpReservationOpenApiVO(DhcpReservationVO vo) {
        if (vo == null) {
            return null;
        }
        ArrayList<DhcpOptionOpenApiVO> options = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)vo.getOptions())) {
            options = vo.getOptions().stream().map(DhcpOptionOpenApiVO::buildByWebVO).toList();
        }
        DhcpReservationOpenApiVO dhcpReservationOpenApiVO = new DhcpReservationOpenApiVO();
        dhcpReservationOpenApiVO.setId(vo.getId());
        dhcpReservationOpenApiVO.setNetId(vo.getNetId());
        dhcpReservationOpenApiVO.setNetName(vo.getNetName());
        dhcpReservationOpenApiVO.setDescription(vo.getDescription());
        dhcpReservationOpenApiVO.setMac(vo.getMac());
        dhcpReservationOpenApiVO.setIp(vo.getIp());
        dhcpReservationOpenApiVO.setStatus(vo.getStatus());
        dhcpReservationOpenApiVO.setExportToIpMacBinding(vo.getExportToIpMacBinding() != null && vo.getExportToIpMacBinding() != false);
        dhcpReservationOpenApiVO.setClientName(vo.getClientName());
        dhcpReservationOpenApiVO.setName(vo.getName());
        dhcpReservationOpenApiVO.setOptions(options);
        dhcpReservationOpenApiVO.setExistOptions(vo.getExistOptions());
        dhcpReservationOpenApiVO.setType(vo.getType());
        dhcpReservationOpenApiVO.setShowingType(vo.getShowingType());
        dhcpReservationOpenApiVO.setModel(vo.getModel());
        dhcpReservationOpenApiVO.setModelVersion(vo.getModelVersion());
        dhcpReservationOpenApiVO.setServerName(vo.getServerName());
        dhcpReservationOpenApiVO.setServerType(vo.getServerType());
        dhcpReservationOpenApiVO.setServerMac(vo.getServerMac());
        dhcpReservationOpenApiVO.setServerStackId(vo.getServerStackId());
        dhcpReservationOpenApiVO.setAbnormal(vo.getAbnormal());
        return dhcpReservationOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getNetId() {
        return this.netId;
    }

    @Generated
    public String getNetName() {
        return this.netName;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<DhcpOptionOpenApiVO> getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getExportToIpMacBinding() {
        return this.exportToIpMacBinding;
    }

    @Deprecated
    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Integer> getExistOptions() {
        return this.existOptions;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getShowingType() {
        return this.showingType;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getServerType() {
        return this.serverType;
    }

    @Generated
    public String getServerMac() {
        return this.serverMac;
    }

    @Generated
    public String getServerStackId() {
        return this.serverStackId;
    }

    @Generated
    public Integer getAbnormal() {
        return this.abnormal;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setNetId(String netId) {
        this.netId = netId;
    }

    @Generated
    public void setNetName(String netName) {
        this.netName = netName;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setOptions(List<DhcpOptionOpenApiVO> options) {
        this.options = options;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setExportToIpMacBinding(Boolean exportToIpMacBinding) {
        this.exportToIpMacBinding = exportToIpMacBinding;
    }

    @Deprecated
    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setExistOptions(List<Integer> existOptions) {
        this.existOptions = existOptions;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setShowingType(String showingType) {
        this.showingType = showingType;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Generated
    public void setServerMac(String serverMac) {
        this.serverMac = serverMac;
    }

    @Generated
    public void setServerStackId(String serverStackId) {
        this.serverStackId = serverStackId;
    }

    @Generated
    public void setAbnormal(Integer abnormal) {
        this.abnormal = abnormal;
    }

    @Generated
    public String toString() {
        return "DhcpReservationOpenApiVO(id=" + this.getId() + ", description=" + this.getDescription() + ", netId=" + this.getNetId() + ", netName=" + this.getNetName() + ", mac=" + this.getMac() + ", ip=" + this.getIp() + ", options=" + this.getOptions() + ", status=" + this.getStatus() + ", exportToIpMacBinding=" + this.getExportToIpMacBinding() + ", clientName=" + this.getClientName() + ", name=" + this.getName() + ", existOptions=" + this.getExistOptions() + ", type=" + this.getType() + ", showingType=" + this.getShowingType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", serverName=" + this.getServerName() + ", serverType=" + this.getServerType() + ", serverMac=" + this.getServerMac() + ", serverStackId=" + this.getServerStackId() + ", abnormal=" + this.getAbnormal() + ")";
    }

    @Generated
    public DhcpReservationOpenApiVO(String id, String description, String netId, String netName, String mac, String ip, List<DhcpOptionOpenApiVO> options, Boolean status, Boolean exportToIpMacBinding, String clientName, String name, List<Integer> existOptions, Integer type, String showingType, String model, String modelVersion, String serverName, String serverType, String serverMac, String serverStackId, Integer abnormal) {
        this.id = id;
        this.description = description;
        this.netId = netId;
        this.netName = netName;
        this.mac = mac;
        this.ip = ip;
        this.options = options;
        this.status = status;
        this.exportToIpMacBinding = exportToIpMacBinding;
        this.clientName = clientName;
        this.name = name;
        this.existOptions = existOptions;
        this.type = type;
        this.showingType = showingType;
        this.model = model;
        this.modelVersion = modelVersion;
        this.serverName = serverName;
        this.serverType = serverType;
        this.serverMac = serverMac;
        this.serverStackId = serverStackId;
        this.abnormal = abnormal;
    }

    @Generated
    public DhcpReservationOpenApiVO() {
    }
}

