/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.DhcpReservationVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class CreateDhcpReservationOpenApiVO {
    @NotNull(message="Parameter [netId] should not be null.")
    @Schema(name="netId", description="This field represents LAN Network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface")
    private @NotNull(message="Parameter [netId] should not be null.") String netId;
    @NotNull(message="Parameter [mac] should not be null.")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.")
    @Schema(name="mac", description="Device MAC address, format: AA-BB-CC-11-22-33")
    @a
    private @NotNull(message="Parameter [mac] should not be null.") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.") String mac;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.")
    @Schema(name="ip", description="Reserved IP address")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.") String ip;
    @Schema(name="options", description="Advanced DHCP options")
    private List<DhcpOptionOpenApiVO> options;
    @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    @Schema(name="description", description="Description of DHCP reservation. Description should contain 1 to 128 characters")
    private @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String description;
    @NotNull(message="Parameter [status] should not be null.")
    @Schema(name="status", description="DHCP reservation enable status")
    private @NotNull(message="Parameter [status] should not be null.") Boolean status;
    @Schema(name="confirmConflict", description="True when creating an entry with IP and IP-MAC Binding conflicts confirmed")
    private Boolean confirmConflict;
    @Schema(name="serverType", description="Dhcp Server Device Type")
    private String serverType;
    @Schema(name="serverMac", description="Dhcp Server Device Mac")
    @a
    private String serverMac;
    @Schema(name="serverStackId", description="Dhcp Server Stack ID")
    private String serverStackId;

    public DhcpReservationVO toDhcpReservationVO() {
        List<Object> optionVOList = new ArrayList();
        if (!CollectionUtils.isEmpty(this.options)) {
            optionVOList = this.options.stream().map(DhcpOptionOpenApiVO::buildWebVO).toList();
        }
        return DhcpReservationVO.builder().netId(this.netId).mac(this.mac).ip(this.ip).options(optionVOList).description(this.description).status(this.status).confirmConflict(this.confirmConflict).serverType(this.serverType).serverMac(this.serverMac).serverStackId(this.serverStackId).build();
    }

    @Generated
    public String getNetId() {
        return this.netId;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<DhcpOptionOpenApiVO> getOptions() {
        return this.options;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getConfirmConflict() {
        return this.confirmConflict;
    }

    @Generated
    public String getServerType() {
        return this.serverType;
    }

    @Generated
    public String getServerMac() {
        return this.serverMac;
    }

    @Generated
    public String getServerStackId() {
        return this.serverStackId;
    }

    @Generated
    public void setNetId(String netId) {
        this.netId = netId;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setOptions(List<DhcpOptionOpenApiVO> options) {
        this.options = options;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setConfirmConflict(Boolean confirmConflict) {
        this.confirmConflict = confirmConflict;
    }

    @Generated
    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Generated
    public void setServerMac(String serverMac) {
        this.serverMac = serverMac;
    }

    @Generated
    public void setServerStackId(String serverStackId) {
        this.serverStackId = serverStackId;
    }

    @Generated
    public String toString() {
        return "CreateDhcpReservationOpenApiVO(netId=" + this.getNetId() + ", mac=" + this.getMac() + ", ip=" + this.getIp() + ", options=" + this.getOptions() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", confirmConflict=" + this.getConfirmConflict() + ", serverType=" + this.getServerType() + ", serverMac=" + this.getServerMac() + ", serverStackId=" + this.getServerStackId() + ")";
    }

    @Generated
    public CreateDhcpReservationOpenApiVO(String netId, String mac, String ip, List<DhcpOptionOpenApiVO> options, String description, Boolean status, Boolean confirmConflict, String serverType, String serverMac, String serverStackId) {
        this.netId = netId;
        this.mac = mac;
        this.ip = ip;
        this.options = options;
        this.description = description;
        this.status = status;
        this.confirmConflict = confirmConflict;
        this.serverType = serverType;
        this.serverMac = serverMac;
        this.serverStackId = serverStackId;
    }

    @Generated
    public CreateDhcpReservationOpenApiVO() {
    }
}

