/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.DdnsIntervalOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.DdnsVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class CreateDdnsOpenApiVO {
    @NotNull(message="Parameter [service] should not be null.")
    @Range(min=0L, max=5L)
    @Schema(name="service", description="Dynamic DNS service type. Service should be a value as follows: 0: DynDNS, 1: NO-IP, 2: Peanuthull, 3: Comexe, 4: Custom, 5: TP-Link DDNS")
    private @NotNull(message="Parameter [service] should not be null.") @Range(min=0L, max=5L) Integer service;
    @NotNull(message="Parameter [status] should not be null.")
    @Schema(name="status", description="Dynamic DNS enable status")
    private @NotNull(message="Parameter [status] should not be null.") Boolean status;
    @NotNull(message="Parameter [interfacePortId] should not be null.")
    @Schema(name="interfacePortId", description="This field represents interface Port ID")
    private @NotNull(message="Parameter [interfacePortId] should not be null.") String interfacePortId;
    @NotNull(message="Parameter [username] should not be null.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [username] should be visible ASCII, between 1 and 128 characters.")
    @Schema(name="username", description="Dynamic DNS username. Username should contain 1 to 128 characters")
    private @NotNull(message="Parameter [username] should not be null.") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [username] should be visible ASCII, between 1 and 128 characters.") String username;
    @NotNull(message="Parameter [password] should not be null.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [password] should be visible ASCII, between 1 and 128 characters.")
    @Schema(name="password", description="Dynamic DNS password. Password should contain 1 to 128 characters")
    private @NotNull(message="Parameter [password] should not be null.") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [password] should be visible ASCII, between 1 and 128 characters.") String password;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    @Schema(name="domainName", description="Dynamic DNS domainName, valid when parameter [service] is 0, 1 or 4")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domainName;
    @Valid
    @Schema(name="interval", description="Dynamic DNS interval configuration. You can configure one of two intervals, when parameter [service] is 2 or 3, you can only choose [updateInterval] to configure, when parameter [service] is 5, you don\u2019t need to configure interval.")
    private DdnsIntervalOpenApiVO interval;
    @Schema(name="updateUrl", description="Dynamic DNS updateUrl, valid when parameter [service] is 4. Update URL must contain [USERNAME], [PASSWORD] and [DOMAIN], and Update-URL will be applied to all custom entries")
    private String updateUrl;

    public DdnsVO toDdnsVO() {
        return DdnsVO.builder().service(this.service).status(this.status).interfacePortId(this.interfacePortId).username(this.username).password(this.password).domainName(this.domainName).updateInterval(this.interval.getUpdateInterval()).customInterval(this.interval.getCustomInterval()).updateUrl(this.updateUrl).build();
    }

    public OperationResponse check() {
        if ((this.service == 0 || this.service == 1 || this.service == 4 || this.service == 5) && this.domainName == null) {
            return new OperationResponse(b.d, "Parameter [domainName] should not be null.", null);
        }
        if (this.interval.getCustomInterval() != null && this.interval.getUpdateInterval() != null) {
            return new OperationResponse(b.d, "You should only configure one of the parameter: [updateInterval], [customInterval]", null);
        }
        if (this.interval.getCustomInterval() == null && this.interval.getUpdateInterval() == null && this.service != 5) {
            return new OperationResponse(b.d, "You should at least configure one of the parameter: [updateInterval], [customInterval]", null);
        }
        if ((this.service == 2 || this.service == 3) && this.interval.getCustomInterval() != null) {
            return new OperationResponse(b.d, "You could configure parameter [customInterval] when [service] is 0, 1 or 4", null);
        }
        if (this.service == 4 && T.a((String)this.updateUrl)) {
            return new OperationResponse(b.d, "Parameter [updateUrl] should not be null.", null);
        }
        if (!(this.service != 4 || this.updateUrl.contains("[USERNAME]") && this.updateUrl.contains("[PASSWORD]") && this.updateUrl.contains("[DOMAIN]"))) {
            return new OperationResponse(b.d, "Parameter [updateUrl] must contain [USERNAME], [PASSWORD] and [DOMAIN]", null);
        }
        if (this.service != 4 && this.updateUrl != null) {
            return new OperationResponse(b.d, "You should not config parameter [updateUrl] when [service] is not 4.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Integer getService() {
        return this.service;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getInterfacePortId() {
        return this.interfacePortId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public DdnsIntervalOpenApiVO getInterval() {
        return this.interval;
    }

    @Generated
    public String getUpdateUrl() {
        return this.updateUrl;
    }

    @Generated
    public void setService(Integer service) {
        this.service = service;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setInterfacePortId(String interfacePortId) {
        this.interfacePortId = interfacePortId;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setInterval(DdnsIntervalOpenApiVO interval) {
        this.interval = interval;
    }

    @Generated
    public void setUpdateUrl(String updateUrl) {
        this.updateUrl = updateUrl;
    }

    @Generated
    public String toString() {
        return "CreateDdnsOpenApiVO(service=" + this.getService() + ", status=" + this.getStatus() + ", interfacePortId=" + this.getInterfacePortId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", domainName=" + this.getDomainName() + ", interval=" + this.getInterval() + ", updateUrl=" + this.getUpdateUrl() + ")";
    }

    @Generated
    public CreateDdnsOpenApiVO(Integer service, Boolean status, String interfacePortId, String username, String password, String domainName, DdnsIntervalOpenApiVO interval, String updateUrl) {
        this.service = service;
        this.status = status;
        this.interfacePortId = interfacePortId;
        this.username = username;
        this.password = password;
        this.domainName = domainName;
        this.interval = interval;
        this.updateUrl = updateUrl;
    }

    @Generated
    public CreateDdnsOpenApiVO() {
    }
}

