/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.SshSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SSHSetting", description="SSH setting")
public class SshSettingOpenApiVO {
    @Schema(name="sshEnable", description="Whether to enable SSH")
    @NotNull
    private Boolean sshEnable;
    @Schema(name="sshServerPort", description="SSH server port should be 22 or within the range of 1025-65535.")
    @NumberSet(value={22}, ranges={@Range(min=1025L, max=65535L)}, message="SshServerPort should be 22 or within the range of 1025-65535.")
    @NotNull
    private Integer sshServerPort;
    @Schema(name="layer3Access", description="Whether to enable layer 3 accessibility")
    private Boolean layer3Access;

    public static SshSettingOpenApiVO fromVO(SshSettingVO vo) {
        if (Objects.isNull(vo)) {
            return new SshSettingOpenApiVO();
        }
        return SshSettingOpenApiVO.builder().sshEnable(vo.getSshEnable()).sshServerPort(vo.getSshServerPort()).layer3Access(vo.getLayer3Access()).build();
    }

    public static SshSettingVO toVO(SshSettingOpenApiVO openApiVO) {
        SshSettingVO vo = new SshSettingVO();
        if (Objects.isNull(openApiVO)) {
            return vo;
        }
        vo.setSshEnable(openApiVO.getSshEnable());
        vo.setSshServerPort(openApiVO.getSshServerPort());
        vo.setLayer3Access(openApiVO.getLayer3Access());
        return vo;
    }

    @Generated
    public static SshSettingOpenApiVOBuilder builder() {
        return new SshSettingOpenApiVOBuilder();
    }

    @Generated
    public Boolean getSshEnable() {
        return this.sshEnable;
    }

    @Generated
    public Integer getSshServerPort() {
        return this.sshServerPort;
    }

    @Generated
    public Boolean getLayer3Access() {
        return this.layer3Access;
    }

    @Generated
    public void setSshEnable(Boolean sshEnable) {
        this.sshEnable = sshEnable;
    }

    @Generated
    public void setSshServerPort(Integer sshServerPort) {
        this.sshServerPort = sshServerPort;
    }

    @Generated
    public void setLayer3Access(Boolean layer3Access) {
        this.layer3Access = layer3Access;
    }

    @Generated
    public SshSettingOpenApiVO(Boolean sshEnable, Integer sshServerPort, Boolean layer3Access) {
        this.sshEnable = sshEnable;
        this.sshServerPort = sshServerPort;
        this.layer3Access = layer3Access;
    }

    @Generated
    public SshSettingOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "SshSettingOpenApiVO(sshEnable=" + this.getSshEnable() + ", sshServerPort=" + this.getSshServerPort() + ", layer3Access=" + this.getLayer3Access() + ")";
    }

    @Generated
    public static class SshSettingOpenApiVOBuilder {
        @Generated
        private Boolean sshEnable;
        @Generated
        private Integer sshServerPort;
        @Generated
        private Boolean layer3Access;

        @Generated
        SshSettingOpenApiVOBuilder() {
        }

        @Generated
        public SshSettingOpenApiVOBuilder sshEnable(Boolean sshEnable) {
            this.sshEnable = sshEnable;
            return this;
        }

        @Generated
        public SshSettingOpenApiVOBuilder sshServerPort(Integer sshServerPort) {
            this.sshServerPort = sshServerPort;
            return this;
        }

        @Generated
        public SshSettingOpenApiVOBuilder layer3Access(Boolean layer3Access) {
            this.layer3Access = layer3Access;
            return this;
        }

        @Generated
        public SshSettingOpenApiVO build() {
            return new SshSettingOpenApiVO(this.sshEnable, this.sshServerPort, this.layer3Access);
        }

        @Generated
        public String toString() {
            return "SshSettingOpenApiVO.SshSettingOpenApiVOBuilder(sshEnable=" + this.sshEnable + ", sshServerPort=" + this.sshServerPort + ", layer3Access=" + this.layer3Access + ")";
        }
    }
}

