/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.SnmpSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class SnmpSettingOpenApiVO {
    @NotNull(message="Parameter [snmpV1V2CEnable] should not be null.")
    @Schema(name="snmpV1V2CEnable", description="SNMPv1 & SNMPv2c enable status")
    private @NotNull(message="Parameter [snmpV1V2CEnable] should not be null.") Boolean snmpV1V2CEnable;
    @Pattern(regexp="^[\\041\\043-\\076\\0100-\\0176]{1,64}$", message="Community string, valid when parameter [snmpV1V2CEnable] is true. The communityString should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe communityString should not contain consecutive identical characters.")
    @Schema(name="communityString", description="Community string, valid when parameter [snmpV1V2CEnable] is true. The communityString should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe communityString should not contain consecutive identical characters.")
    private @Pattern(regexp="^[\\041\\043-\\076\\0100-\\0176]{1,64}$", message="Community string, valid when parameter [snmpV1V2CEnable] is true. The communityString should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe communityString should not contain consecutive identical characters.") String communityString;
    @NotNull(message="Parameter [snmpV3Enable] should not be null.")
    @Schema(name="snmpV3Enable", description="SNMPv3 enable status")
    private @NotNull(message="Parameter [snmpV3Enable] should not be null.") Boolean snmpV3Enable;
    @Pattern(regexp="^[0-9a-zA-Z\\-\\_]{1,30}$", message="Parameter [username] should be letter,number,-,_, between 1 and 30.")
    @Schema(name="username", description="Username, valid when parameter [snmpV3Enable] is true. Username should contain 1 to 30 characters")
    private @Pattern(regexp="^[0-9a-zA-Z\\-\\_]{1,30}$", message="Parameter [username] should be letter,number,-,_, between 1 and 30.") String username;
    @Pattern(regexp="^[\\041\\043-\\076\\0100-\\0133\\0135-\\0176]{8,32}$", message="The password should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe password should not contain consecutive identical characters. \nUsername and Password should not be the same.")
    @Schema(name="password", description="The password should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe password should not contain consecutive identical characters. \nUsername and Password should not be the same.")
    private @Pattern(regexp="^[\\041\\043-\\076\\0100-\\0133\\0135-\\0176]{8,32}$", message="The password should contain at least 10 characters, using a combination of numbers, letters or special characters. \nThe password should not contain consecutive identical characters. \nUsername and Password should not be the same.") String password;

    public static SnmpSettingOpenApiVO toOpenApiVO(SnmpSettingVO vo) {
        SnmpSettingOpenApiVO openApiVO = new SnmpSettingOpenApiVO();
        openApiVO.setSnmpV1V2CEnable(vo.getSnmpV1V2CEnable());
        openApiVO.setSnmpV3Enable(vo.getSnmpV3Enable());
        if (Boolean.TRUE.equals(vo.getSnmpV1V2CEnable())) {
            openApiVO.setCommunityString(vo.getCommunityString());
        }
        if (Boolean.TRUE.equals(vo.getSnmpV3Enable())) {
            openApiVO.setUsername(vo.getUsername());
            openApiVO.setPassword(vo.getPassword());
        }
        return openApiVO;
    }

    public OperationResponse modifyCheck() {
        if (Boolean.TRUE.equals(this.snmpV1V2CEnable) && T.a((String)this.communityString)) {
            return new OperationResponse(b.d, "Parameter [communityString] should not be null.", null);
        }
        if (Boolean.TRUE.equals(this.snmpV3Enable) && T.a((String)this.username)) {
            return new OperationResponse(b.d, "Parameter [username] should not be null.", null);
        }
        if (Boolean.TRUE.equals(this.snmpV3Enable) && T.a((String)this.password)) {
            return new OperationResponse(b.d, "Parameter [password] should not be null.", null);
        }
        return OperationResponse.SUCCESS;
    }

    public SnmpSettingVO toVO() {
        SnmpSettingVO vo = new SnmpSettingVO();
        vo.setSnmpV1V2CEnable(this.snmpV1V2CEnable);
        vo.setSnmpV3Enable(this.snmpV3Enable);
        if (Boolean.TRUE.equals(this.snmpV1V2CEnable)) {
            vo.setCommunityString(this.communityString);
        }
        if (Boolean.TRUE.equals(this.snmpV3Enable)) {
            vo.setUsername(this.username);
            vo.setPassword(this.password);
        }
        return vo;
    }

    @Generated
    public Boolean getSnmpV1V2CEnable() {
        return this.snmpV1V2CEnable;
    }

    @Generated
    public String getCommunityString() {
        return this.communityString;
    }

    @Generated
    public Boolean getSnmpV3Enable() {
        return this.snmpV3Enable;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setSnmpV1V2CEnable(Boolean snmpV1V2CEnable) {
        this.snmpV1V2CEnable = snmpV1V2CEnable;
    }

    @Generated
    public void setCommunityString(String communityString) {
        this.communityString = communityString;
    }

    @Generated
    public void setSnmpV3Enable(Boolean snmpV3Enable) {
        this.snmpV3Enable = snmpV3Enable;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String toString() {
        return "SnmpSettingOpenApiVO(snmpV1V2CEnable=" + this.getSnmpV1V2CEnable() + ", communityString=" + this.getCommunityString() + ", snmpV3Enable=" + this.getSnmpV3Enable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public SnmpSettingOpenApiVO(Boolean snmpV1V2CEnable, String communityString, Boolean snmpV3Enable, String username, String password) {
        this.snmpV1V2CEnable = snmpV1V2CEnable;
        this.communityString = communityString;
        this.snmpV3Enable = snmpV3Enable;
        this.username = username;
        this.password = password;
    }

    @Generated
    public SnmpSettingOpenApiVO() {
    }
}

