/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.profile.gatewayqosservice.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class GatewayQosServiceOpenApiVO {
    @Schema(name="name", description="The name of Gateway QoS Service should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] can not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.")
    private @NotNull(message="Parameter [name] can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] can only be 1 to 64 characters, with no spaces at the beginning and end.") String name;
    @Schema(name="protocol", description="The protocol of Gateway QoS Service should be a value as follows: 0: TCP, 1: UDP, 2: TCP/UDP, 3: ICMP, 4: Other.")
    @NotNull(message="Parameter [protocol] can not be null.")
    @Range(min=0L, max=4L, message="Parameter [protocol] can only be 0, 1, 2, 3 or 4.")
    private @NotNull(message="Parameter [protocol] can not be null.") @Range(min=0L, max=4L, message="Parameter [protocol] can only be 0, 1, 2, 3 or 4.") Integer protocol;
    @Schema(name="sourceStartPort", description="The start port of Source Port Range. It must be less than the end port. It should be within the range of 0-65535 when protocol is 0(TCP), 1(UDP) or 2(TCP/UDP).")
    @Range(min=0L, max=65535L, message="Parameter [sourceStartPort] must be between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Parameter [sourceStartPort] must be between 0 and 65535.") Integer sourceStartPort;
    @Schema(name="sourceEndPort", description="The end port of Source Port Range. It must be more than the start port. It should be within the range of 0-65535 when protocol is 0(TCP), 1(UDP) or 2(TCP/UDP).")
    @Range(min=0L, max=65535L, message="Parameter [sourceEndPort] must be between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Parameter [sourceEndPort] must be between 0 and 65535.") Integer sourceEndPort;
    @Schema(name="destStartPort", description="The start port of Destination Port Range. It must be less than the end port. It should be within the range of 0-65535 when protocol is 0(TCP), 1(UDP) or 2(TCP/UDP).")
    @Range(min=0L, max=65535L, message="Parameter [destStartPort] must be between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Parameter [destStartPort] must be between 0 and 65535.") Integer destStartPort;
    @Schema(name="destEndPort", description="The end port of Destination Port Range. It must be more than the start port. It should be within the range of 0-65535 when protocol is 0(TCP), 1(UDP) or 2(TCP/UDP).")
    @Range(min=0L, max=65535L, message="Parameter [destEndPort] must be between 0 and 65535.")
    private @Range(min=0L, max=65535L, message="Parameter [destEndPort] must be between 0 and 65535.") Integer destEndPort;
    @Schema(name="type", description="The type cannot be null and should be within the range of 0-255 when protocol is 3(ICMP).")
    @Range(min=0L, max=255L, message="Parameter [type] must be between 0 and 255.")
    private @Range(min=0L, max=255L, message="Parameter [type] must be between 0 and 255.") Integer type;
    @Schema(name="code", description="The code cannot be null and should be within the range of 0-255 when protocol is 3(ICMP).")
    @Range(min=0L, max=255L, message="Parameter [code] must be between 0 and 255.")
    private @Range(min=0L, max=255L, message="Parameter [code] must be between 0 and 255.") Integer code;
    @Schema(name="protoNum", description="The protoNum cannot be null and should be within the range of 1-255 when protocol is 4(Other).")
    @Range(min=1L, max=255L, message="Parameter [protoNum] must be between 1 and 255.")
    private @Range(min=1L, max=255L, message="Parameter [protoNum] must be between 1 and 255.") Integer protoNum;
    @Schema(name="description", description="The description of Gateway QoS Service should contain 0 to 128 characters.")
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [description] can not be more than 128 character.")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [description] can not be more than 128 character.") String description;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getSourceStartPort() {
        return this.sourceStartPort;
    }

    @Generated
    public Integer getSourceEndPort() {
        return this.sourceEndPort;
    }

    @Generated
    public Integer getDestStartPort() {
        return this.destStartPort;
    }

    @Generated
    public Integer getDestEndPort() {
        return this.destEndPort;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public Integer getProtoNum() {
        return this.protoNum;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setProtocol(Integer protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setSourceStartPort(Integer sourceStartPort) {
        this.sourceStartPort = sourceStartPort;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setSourceEndPort(Integer sourceEndPort) {
        this.sourceEndPort = sourceEndPort;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setDestStartPort(Integer destStartPort) {
        this.destStartPort = destStartPort;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setDestEndPort(Integer destEndPort) {
        this.destEndPort = destEndPort;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setCode(Integer code) {
        this.code = code;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setProtoNum(Integer protoNum) {
        this.protoNum = protoNum;
        return this;
    }

    @Generated
    public GatewayQosServiceOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }
}

