/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.DeviceOuiModeQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.LagInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.VlanOuiModeQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.DeviceOuiModeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.LagInfoVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.VlanOuiModeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanSwitchQueryOpenApiVO {
    @Schema(name="id", description="Rule ID")
    private String id;
    @Schema(name="enable", description="Switch Rule state.")
    private Boolean enable;
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Switch Rule name should contain 1 to 128 characters.")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @Schema(name="mode", description="Switch Rule type should be a value as follows: 0: All device port; 1: Custom device port")
    private Integer mode;
    @Schema(name="deviceList", description="When mode is 0, Show configured device info.")
    private List<DeviceOuiModeQueryOpenApiVO> deviceList;
    @Schema(name="ruleCombine", description="Basic vlan-oui-priority configuration of oui based vlan rule.")
    private List<VlanOuiModeQueryOpenApiVO> ruleCombine;

    public static OuiBasedVlanSwitchQueryOpenApiVO buildByWebVO(OuiBasedVlanRuleVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OuiBasedVlanSwitchQueryOpenApiVO openApiVO = new OuiBasedVlanSwitchQueryOpenApiVO();
        openApiVO.setId(webVO.getId());
        openApiVO.setName(webVO.getName());
        openApiVO.setEnable(webVO.getEnable());
        openApiVO.setMode(webVO.getMode());
        openApiVO.setDeviceList(OuiBasedVlanSwitchQueryOpenApiVO.buildDeviceListByWebVO(webVO.getDeviceList()));
        openApiVO.setRuleCombine(OuiBasedVlanSwitchQueryOpenApiVO.buildRuleCombineByWebVO(webVO.getRuleCombine()));
        return openApiVO;
    }

    private static List<VlanOuiModeQueryOpenApiVO> buildRuleCombineByWebVO(List<VlanOuiModeVO> ruleCombine) {
        ArrayList<VlanOuiModeQueryOpenApiVO> vlanOuiList = new ArrayList<VlanOuiModeQueryOpenApiVO>();
        if (CollectionUtils.isEmpty(ruleCombine)) {
            return vlanOuiList;
        }
        for (VlanOuiModeVO vlanOuiModeVO : ruleCombine) {
            VlanOuiModeQueryOpenApiVO vo = new VlanOuiModeQueryOpenApiVO();
            vo.setOuiProfileId(vlanOuiModeVO.getOuiProfileId());
            vo.setOuiProfileName(vlanOuiModeVO.getOuiProfileName());
            vo.setPriority(vlanOuiModeVO.getPriority());
            vo.setVlanId(vlanOuiModeVO.getVlanId());
            vlanOuiList.add(vo);
        }
        return vlanOuiList;
    }

    private static List<DeviceOuiModeQueryOpenApiVO> buildDeviceListByWebVO(List<DeviceOuiModeVO> deviceList) {
        ArrayList<DeviceOuiModeQueryOpenApiVO> openApiDeviceList = new ArrayList<DeviceOuiModeQueryOpenApiVO>();
        if (CollectionUtils.isEmpty(deviceList)) {
            return openApiDeviceList;
        }
        for (DeviceOuiModeVO deviceOuiModeVO : deviceList) {
            DeviceOuiModeQueryOpenApiVO openApiVO = new DeviceOuiModeQueryOpenApiVO();
            openApiVO.setDeviceMac(deviceOuiModeVO.getDeviceMac());
            openApiVO.setDeviceName(deviceOuiModeVO.getDeviceName());
            openApiVO.setPortList(deviceOuiModeVO.getPortList());
            openApiVO.setLagList(deviceOuiModeVO.getLagList());
            openApiVO.setLagInfo(OuiBasedVlanSwitchQueryOpenApiVO.buildLagInfoByWebVO(deviceOuiModeVO.getLagInfo()));
            openApiDeviceList.add(openApiVO);
        }
        return openApiDeviceList;
    }

    private static List<LagInfoOpenApiVO> buildLagInfoByWebVO(List<LagInfoVO> lagInfo) {
        if (CollectionUtils.isEmpty(lagInfo)) {
            return new ArrayList<LagInfoOpenApiVO>();
        }
        ArrayList<LagInfoOpenApiVO> lagInfoOpenApiVOList = new ArrayList<LagInfoOpenApiVO>();
        for (LagInfoVO vo : lagInfo) {
            LagInfoOpenApiVO openApiVO = new LagInfoOpenApiVO();
            openApiVO.setName(vo.getName());
            openApiVO.setLag(vo.getLagId());
            openApiVO.setPorts(vo.getPorts());
            lagInfoOpenApiVOList.add(openApiVO);
        }
        return lagInfoOpenApiVOList;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<DeviceOuiModeQueryOpenApiVO> getDeviceList() {
        return this.deviceList;
    }

    @Generated
    public List<VlanOuiModeQueryOpenApiVO> getRuleCombine() {
        return this.ruleCombine;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setDeviceList(List<DeviceOuiModeQueryOpenApiVO> deviceList) {
        this.deviceList = deviceList;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchQueryOpenApiVO setRuleCombine(List<VlanOuiModeQueryOpenApiVO> ruleCombine) {
        this.ruleCombine = ruleCombine;
        return this;
    }
}

