/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.LagInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.LagInfoVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanDeviceInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanSwitchInfoOpenApiVO {
    @Schema(name="name", description="Device name.")
    private String name;
    @Schema(name="mac", description="Device mac.")
    @a
    private String mac;
    @Schema(name="oldFirmwareDevice", description="If switch supports only one oui combine, this key word is \"true\"")
    private Boolean oldFirmwareDevice;
    @Schema(name="configuredInOuiId", description="Indicate ID of \"oldFirmwareDevice\" is configured in specific oui based vlan.")
    private String configuredInOuiId;
    @Schema(name="portNum", description="Switch port number. Valid port range is from 1 to \"portNum\"")
    private Integer portNum;
    @Schema(name="lags", description="Switch lag info list.")
    private List<LagInfoOpenApiVO> lags;

    public static OuiBasedVlanSwitchInfoOpenApiVO buildByWebVO(OuiBasedVlanDeviceInfoVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OuiBasedVlanSwitchInfoOpenApiVO openApiVO = new OuiBasedVlanSwitchInfoOpenApiVO();
        openApiVO.setName(webVO.getName());
        openApiVO.setMac(webVO.getMac());
        openApiVO.setOldFirmwareDevice(webVO.getOldFirmwareDevice());
        openApiVO.setConfiguredInOuiId(webVO.getOldFirmwareUsed());
        openApiVO.setPortNum(webVO.getDeviceMisc().getPortNum());
        openApiVO.setLags(OuiBasedVlanSwitchInfoOpenApiVO.buildLagsByWebVO(webVO.getLags()));
        return openApiVO;
    }

    private static List<LagInfoOpenApiVO> buildLagsByWebVO(List<LagInfoVO> lags) {
        ArrayList<LagInfoOpenApiVO> openApiVOS = new ArrayList<LagInfoOpenApiVO>();
        if (CollectionUtils.isEmpty(lags)) {
            return openApiVOS;
        }
        for (LagInfoVO lagInfoVO : lags) {
            LagInfoOpenApiVO openApiVO = new LagInfoOpenApiVO();
            openApiVO.setLag(lagInfoVO.getLagId());
            openApiVO.setName(lagInfoVO.getName());
            openApiVO.setPorts(lagInfoVO.getPorts());
            openApiVOS.add(openApiVO);
        }
        return openApiVOS;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Boolean getOldFirmwareDevice() {
        return this.oldFirmwareDevice;
    }

    @Generated
    public String getConfiguredInOuiId() {
        return this.configuredInOuiId;
    }

    @Generated
    public Integer getPortNum() {
        return this.portNum;
    }

    @Generated
    public List<LagInfoOpenApiVO> getLags() {
        return this.lags;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setOldFirmwareDevice(Boolean oldFirmwareDevice) {
        this.oldFirmwareDevice = oldFirmwareDevice;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setConfiguredInOuiId(String configuredInOuiId) {
        this.configuredInOuiId = configuredInOuiId;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setPortNum(Integer portNum) {
        this.portNum = portNum;
        return this;
    }

    @Generated
    public OuiBasedVlanSwitchInfoOpenApiVO setLags(List<LagInfoOpenApiVO> lags) {
        this.lags = lags;
        return this;
    }
}

