/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.SsidOuiModeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.VlanOuiModeQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.SsidOuiModeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.VlanOuiModeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanApQueryOpenApiVO {
    @Schema(name="id", description="Rule ID")
    private String id;
    @Schema(name="enable", description="Ap Rule state.")
    private Boolean enable;
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Ap Rule name should contain 1 to 128 characters.")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @Schema(name="ssidList", description="Configured ssid list.")
    private List<SsidOuiModeOpenApiVO> ssidList;
    @Schema(name="ruleCombine", description="Basic vlan-oui-priority configuration of oui based rule.")
    private List<VlanOuiModeQueryOpenApiVO> ruleCombine;

    public static OuiBasedVlanApQueryOpenApiVO buildByWebVO(OuiBasedVlanRuleVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OuiBasedVlanApQueryOpenApiVO openApiVO = new OuiBasedVlanApQueryOpenApiVO();
        openApiVO.setId(webVO.getId());
        openApiVO.setName(webVO.getName());
        openApiVO.setEnable(webVO.getEnable());
        openApiVO.setSsidList(OuiBasedVlanApQueryOpenApiVO.buildSsidByWebVO(webVO.getSsidList()));
        openApiVO.setRuleCombine(OuiBasedVlanApQueryOpenApiVO.buildRuleCombineByWebVO(webVO.getRuleCombine()));
        return openApiVO;
    }

    private static List<VlanOuiModeQueryOpenApiVO> buildRuleCombineByWebVO(List<VlanOuiModeVO> ruleCombine) {
        ArrayList<VlanOuiModeQueryOpenApiVO> vlanOuiModeList = new ArrayList<VlanOuiModeQueryOpenApiVO>();
        if (CollectionUtils.isEmpty(ruleCombine)) {
            return vlanOuiModeList;
        }
        for (VlanOuiModeVO webVO : ruleCombine) {
            VlanOuiModeQueryOpenApiVO openApiVO = new VlanOuiModeQueryOpenApiVO();
            openApiVO.setVlanId(webVO.getVlanId());
            openApiVO.setPriority(webVO.getPriority());
            openApiVO.setOuiProfileId(webVO.getOuiProfileId());
            openApiVO.setOuiProfileName(webVO.getOuiProfileName());
            vlanOuiModeList.add(openApiVO);
        }
        return vlanOuiModeList;
    }

    private static List<SsidOuiModeOpenApiVO> buildSsidByWebVO(List<SsidOuiModeVO> ssidList) {
        ArrayList<SsidOuiModeOpenApiVO> ssidOuiModeList = new ArrayList<SsidOuiModeOpenApiVO>();
        if (CollectionUtils.isEmpty(ssidList)) {
            return ssidOuiModeList;
        }
        for (SsidOuiModeVO modeVO : ssidList) {
            SsidOuiModeOpenApiVO ssidOuiMode = new SsidOuiModeOpenApiVO();
            ssidOuiMode.setSsidId(modeVO.getSsidId());
            ssidOuiMode.setSsidName(modeVO.getSsidName());
            ssidOuiModeList.add(ssidOuiMode);
        }
        return ssidOuiModeList;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<SsidOuiModeOpenApiVO> getSsidList() {
        return this.ssidList;
    }

    @Generated
    public List<VlanOuiModeQueryOpenApiVO> getRuleCombine() {
        return this.ruleCombine;
    }

    @Generated
    public OuiBasedVlanApQueryOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OuiBasedVlanApQueryOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public OuiBasedVlanApQueryOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanApQueryOpenApiVO setSsidList(List<SsidOuiModeOpenApiVO> ssidList) {
        this.ssidList = ssidList;
        return this;
    }

    @Generated
    public OuiBasedVlanApQueryOpenApiVO setRuleCombine(List<VlanOuiModeQueryOpenApiVO> ruleCombine) {
        this.ruleCombine = ruleCombine;
        return this;
    }
}

