/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.VlanOuiModeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.VlanOuiModeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanApOpenApiVO {
    @NotNull
    @Schema(name="enable", description="Ap Rule state.")
    private Boolean enable;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Ap Rule name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Schema(name="ssidIdList", description="Configured ssid list.")
    private List<String> ssidIdList;
    @NotNull
    @Valid
    @Schema(name="ruleCombine", description="Basic vlan-oui-priority configuration of oui based vlan rule. Cannot be empty.")
    private List<VlanOuiModeOpenApiVO> ruleCombine;

    public static OuiBasedVlanRuleVO toWebVO(OuiBasedVlanApOpenApiVO ouiBasedVlanApOpenApiVO) {
        if (Objects.isNull(ouiBasedVlanApOpenApiVO)) {
            return null;
        }
        OuiBasedVlanRuleVO ouiBasedVlanRuleVO = new OuiBasedVlanRuleVO();
        ouiBasedVlanRuleVO.setEnable(ouiBasedVlanApOpenApiVO.getEnable());
        ouiBasedVlanRuleVO.setName(ouiBasedVlanApOpenApiVO.getName());
        ouiBasedVlanRuleVO.setSsidIdList(ouiBasedVlanApOpenApiVO.getSsidIdList());
        ouiBasedVlanRuleVO.setRuleCombine(OuiBasedVlanApOpenApiVO.ruleCombineToWebVO(ouiBasedVlanApOpenApiVO.getRuleCombine()));
        return ouiBasedVlanRuleVO;
    }

    private static List<VlanOuiModeVO> ruleCombineToWebVO(List<VlanOuiModeOpenApiVO> ruleCombine) {
        ArrayList<VlanOuiModeVO> vlanOuiModeVOS = new ArrayList<VlanOuiModeVO>();
        if (CollectionUtils.isEmpty(ruleCombine)) {
            return vlanOuiModeVOS;
        }
        for (VlanOuiModeOpenApiVO openApiVO : ruleCombine) {
            VlanOuiModeVO webVO = new VlanOuiModeVO();
            webVO.setVlanId(openApiVO.getVlanId());
            webVO.setPriority(openApiVO.getPriority());
            webVO.setOuiProfileId(openApiVO.getOuiProfileId());
            vlanOuiModeVOS.add(webVO);
        }
        return vlanOuiModeVOS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getSsidIdList() {
        return this.ssidIdList;
    }

    @Generated
    public List<VlanOuiModeOpenApiVO> getRuleCombine() {
        return this.ruleCombine;
    }

    @Generated
    public OuiBasedVlanApOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public OuiBasedVlanApOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanApOpenApiVO setSsidIdList(List<String> ssidIdList) {
        this.ssidIdList = ssidIdList;
        return this;
    }

    @Generated
    public OuiBasedVlanApOpenApiVO setRuleCombine(List<VlanOuiModeOpenApiVO> ruleCombine) {
        this.ruleCombine = ruleCombine;
        return this;
    }
}

