/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswIpSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswIpSettingBriefOpenapiVO")
public class OswIpSettingBriefOpenApiVO {
    @NotNull(message="iP setting parameter [mode] should not be null.")
    @Range(min=0L, max=1L, message="Value of ip setting mode is from 0 to 1.")
    @Schema(name="mode", description="IP Setting mode. Static:0, DHCP:1")
    private @NotNull(message="iP setting parameter [mode] should not be null.") @Range(min=0L, max=1L, message="Value of ip setting mode is from 0 to 1.") Integer mode;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ip", description="Static IP for mode 0, like 192.168.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") String ip;
    @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid IP Mask.")
    @Schema(name="netmask", description="IP Mask, like 255.255.255.0")
    private @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid IP Mask.") String netmask;
    @Schema(name="option12", description="option12")
    private String option12;

    public static OswIpSettingVO buildOswIpSettingVO(OswIpSettingBriefOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return OswIpSettingVO.builder().mode(openApiVO.getMode()).ip(openApiVO.getIp()).netmask(openApiVO.getNetmask()).option12(openApiVO.getOption12()).build();
    }

    public static OswIpSettingBriefOpenApiVO buildOswIpSettingBriefOpenApiVO(OswIpSettingVO vo) {
        if (vo == null) {
            return null;
        }
        OswIpSettingBriefOpenApiVO openApiVO = new OswIpSettingBriefOpenApiVO();
        openApiVO.setMode(vo.getMode());
        openApiVO.setIp(vo.getIp());
        openApiVO.setNetmask(vo.getNetmask());
        openApiVO.setOption12(vo.getOption12());
        return openApiVO;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getOption12() {
        return this.option12;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setOption12(String option12) {
        this.option12 = option12;
    }

    @Generated
    public String toString() {
        return "OswIpSettingBriefOpenApiVO(mode=" + this.getMode() + ", ip=" + this.getIp() + ", netmask=" + this.getNetmask() + ", option12=" + this.getOption12() + ")";
    }

    @Generated
    public OswIpSettingBriefOpenApiVO(Integer mode, String ip, String netmask, String option12) {
        this.mode = mode;
        this.ip = ip;
        this.netmask = netmask;
        this.option12 = option12;
    }

    @Generated
    public OswIpSettingBriefOpenApiVO() {
    }
}

