/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.OswIpSettingBriefOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpGuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpRangeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6GuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.RouteAdvertisementOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DhcpSettingsTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkIpv6ConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.SlaacTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpRelayOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswNetworkOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpOptionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpRangeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpSettingsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.RouteAdvertisementVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.SlaacVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class LanNetworkTemplateQueryOpenApiV3VO {
    @Schema(name="id", description="LAN network ID")
    private String id;
    @JsonProperty(value="primary")
    @Schema(name="primary", description="Primary")
    private Boolean primary;
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters") String name;
    @NotNull
    @Schema(name="purpose", description="LAN network purpose should be a value as follows: 0: VLAN; 1: interface")
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer purpose;
    @Schema(name="interfaceIds", description="Gateway LAN port IDs (acquired from \"Check WAN/LAN status\")")
    private List<String> interfaceIds;
    @Range(min=0L, max=1L)
    @Schema(name="vlanType", description="When purpose is interface, VLANType should be a value as follows: 0: Single; 1: Multiple")
    private @Range(min=0L, max=1L) Integer vlanType;
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    @Schema(name="vlans", description="When purpose is interface and VLANType is 1, batch create VLANs. VLAN format: 200, 1-100.")
    private @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @Schema(name="application", description="Effective device type should be a value as follows: 0: Gateway and Switch; 1: Switch")
    private Integer application;
    @Schema(name="isolation", description="Whether network isolated.")
    private Boolean isolation;
    @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.")
    @Schema(name="vlan", description="When purpose is \"VLAN\" or purpose is \"interface\" and VLANType is 0, vlan should be within the range of 1-4090.When purpose is \"VLAN\" and VLANType is 0 and \"application\" is 1, vlan could be within the range of 1-4094.")
    private @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.") Integer vlan;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.")
    @Schema(name="gatewaySubnet", description="When purpose is interface, gateway subnet is needed. Format: IP/Mask")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.") String gatewaySubnet;
    @Valid
    @Schema(name="dhcpSettings", description="Configure DHCP settings")
    private DhcpSettingsTemplateOpenApiVO dhcpSettings;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    @Schema(name="domain", description="The domain of this network")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domain;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    @Schema(name="igmpSnoopEnable", description="Enable IGMP snooping")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    @Schema(name="fastLeaveEnable", description="IGMP Snooping fast leave enable status")
    private Boolean fastLeaveEnable;
    @Schema(name="mldSnoopEnable", description="Enable MLD snooping")
    private Boolean mldSnoopEnable;
    @Schema(name="dhcpv6Guard", description="Legal DHCPv6 Server")
    private Dhcpv6GuardOpenApiVO dhcpv6Guard;
    @Schema(name="dhcpL2RelayEnable", description="The switch of DHCP L2 relay")
    private Boolean dhcpL2RelayEnable;
    @Valid
    @Schema(name="dhcpGuard", description="Legal DHCP Server")
    private DhcpGuardOpenApiVO dhcpGuard;
    @Schema(name="portal", description="Show portal is enabled or not")
    private Boolean portal;
    @Schema(name="portalId", description="Show portal ID")
    private String portalId;
    @Schema(name="portalName", description="Show related portal name")
    private String portalName;
    @Schema(name="accessControlRule", description="Show AccessControlRule is enabled or not")
    private Boolean accessControlRule;
    @Schema(name="rateLimit", description="Show RateLimit is enabled or not")
    private Boolean rateLimit;
    @Valid
    @Schema(name="lanNeworkIpv6Config", description="LAN network IPv6 config")
    private LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config;
    @Schema(name="allLan", description="When Internet pre-config is closed or Internet pre-config is Universal, allLAN is \"true\"; after adopting gateway, allLAN is \"false\".")
    private Boolean allLan;
    @Schema(name="origName", description="Original name")
    private String origName;
    @Schema(name="arpDetectionEnable", description="Enable arp detection. Only valid when deviceType is 1 and gateway supports this feature.")
    private Boolean arpDetectionEnable;
    @Schema(name="qosQueueEnable", description="The switch of QoS queue.")
    private Boolean qosQueueEnable;
    @Schema(name="queueId", description="QoS queue Id.")
    private Integer queueId;
    @Schema(name="existMultiVlan", description="Whether VLAN Type is Multiple.")
    private Boolean existMultiVlan;
    @Schema(name="existRA", description="Whether RA has been configured.")
    private Boolean existRA;
    @Schema(name="existCustomDhcpOption", description="Whether custom DHCP Options has been configured.")
    private Boolean existCustomDhcpOption;
    @Schema(name="existDhcpNextServer", description="Whether DHCP Next Server has been configured.")
    private Boolean existDhcpNextServer;
    @Schema(name="existArpDetection", description="Whether Arp Detection is configured.")
    private Boolean existArpDetection;
    @Schema(name="existNetworkIsolation", description="Whether Network Isolation is configured.")
    private Boolean existNetworkIsolation;
    @NotNull(message="Parameter [deviceType] should not be null.")
    @Schema(name="deviceType", description="DHCP Server Device type. It should be a value as follows: 0:External Device 1:gateway 2:switch 3:none")
    private @NotNull(message="Parameter [deviceType] should not be null.") Integer deviceType;
    @Schema(name="deviceMac", description="DHCP Server Device mac. Only valid when deviceType is 1 or 2. When deviceType is 1, deviceMac can be empty when there is no gateway in the site.")
    @a
    private String deviceMac;
    @Schema(name="stackId", description="DHCP Server Device stackId. Only valid when deviceType is 2 and the selected device is stack")
    private String stackId;
    @Valid
    @Schema(name="ip", description="Network IP setting. Only valid when deviceType is 2.")
    private OswIpSettingBriefOpenApiVO ip;
    @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.")
    @Schema(name="mode", description="DHCP mode. 0: None 1: DHCP Server 2: DHCP Relay. Only valid when deviceType is 2.")
    private @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.") Integer mode;
    @Valid
    @Schema(name="dhcpServer", description="Network DHCP server settings. Only valid when deviceType is 2 and mode is 1.")
    private OswDhcpServerOpenApiVO dhcpServer;
    @Valid
    @Schema(name="dhcpRelay", description="Network DHCP relay settings. Only valid when deviceType is 2 and mode is 2")
    private OswDhcpRelayOpenApiVO dhcpRelay;
    @Schema(name="totalIpNum", description="Total ip num")
    private Long totalIpNum;
    @Schema(name="dhcpServerNum", description="The number of dhcp server devices in effect, Only valid when vlanType is 0.")
    private Integer dhcpServerNum;
    @Schema(name="subnetOverrideEnable", description="Subnet override enable status")
    private Boolean subnetOverrideEnable;
    @Schema(name="subnetOverride", description="Subnet override")
    private Boolean subnetOverride;

    public static LanNetworkTemplateQueryOpenApiV3VO buildByWebVO(LanNetworkVO lanNetworkVO) {
        LanNetworkTemplateQueryOpenApiV3VO openApiVO = new LanNetworkTemplateQueryOpenApiV3VO();
        openApiVO.setId(lanNetworkVO.getId());
        openApiVO.setPrimary(lanNetworkVO.getPrimary());
        openApiVO.setName(lanNetworkVO.getName());
        openApiVO.setPurpose(LanNetworkTemplateQueryOpenApiV3VO.buildPurpose(lanNetworkVO.getPurpose()));
        openApiVO.setInterfaceIds(lanNetworkVO.getInterfaceIds());
        openApiVO.setVlanType(lanNetworkVO.getVlanType());
        openApiVO.setVlans(lanNetworkVO.getVlans());
        openApiVO.setApplication(lanNetworkVO.getApplication());
        openApiVO.setIsolation(lanNetworkVO.getIsolation());
        openApiVO.setVlan(lanNetworkVO.getVlan());
        openApiVO.setGatewaySubnet(lanNetworkVO.getGatewaySubnet());
        openApiVO.setDhcpSettings(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpSettingsVO(lanNetworkVO.getDhcpSettings()));
        openApiVO.setDomain(lanNetworkVO.getDomain());
        openApiVO.setIgmpSnoopEnable(lanNetworkVO.getIgmpSnoopEnable());
        openApiVO.setFastLeaveEnable(lanNetworkVO.getFastLeaveEnable());
        openApiVO.setMldSnoopEnable(lanNetworkVO.getMldSnoopEnable());
        openApiVO.setDhcpv6Guard(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpv6Guard(lanNetworkVO.getDhcpv6Guard()));
        openApiVO.setDhcpL2RelayEnable(lanNetworkVO.getDhcpL2RelayEnable());
        openApiVO.setDhcpGuard(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpGuard(lanNetworkVO.getDhcpGuard()));
        openApiVO.setPortal(lanNetworkVO.getPortal());
        openApiVO.setPortalId(lanNetworkVO.getPortalId());
        openApiVO.setPortalName(lanNetworkVO.getPortalName());
        openApiVO.setAccessControlRule(lanNetworkVO.getAccessControlRule());
        openApiVO.setRateLimit(lanNetworkVO.getRateLimit());
        openApiVO.setLanNetworkIpv6Config(LanNetworkTemplateQueryOpenApiV3VO.buildLanNetworkIpv6Config(lanNetworkVO.getLanNetworkIpv6Config()));
        openApiVO.setAllLan(lanNetworkVO.getAllLan());
        openApiVO.setOrigName(lanNetworkVO.getOrigName());
        openApiVO.setArpDetectionEnable(lanNetworkVO.getArpDetectionEnable());
        openApiVO.setQosQueueEnable(lanNetworkVO.getQosQueueEnable());
        openApiVO.setQueueId(lanNetworkVO.getQueueId());
        openApiVO.setExistMultiVlan(lanNetworkVO.isExistMultiVlan());
        openApiVO.setExistRA(lanNetworkVO.isExistRA());
        openApiVO.setExistCustomDhcpOption(lanNetworkVO.isExistCustomDhcpOption());
        openApiVO.setExistDhcpNextServer(lanNetworkVO.isExistDhcpNextServer());
        openApiVO.setExistArpDetection(lanNetworkVO.isExistArpDetection());
        openApiVO.setExistNetworkIsolation(lanNetworkVO.isExistNetworkIsolation());
        openApiVO.setDeviceType(lanNetworkVO.getDeviceType());
        openApiVO.setDeviceMac(lanNetworkVO.getDeviceMac());
        openApiVO.setStackId(lanNetworkVO.getStackId());
        openApiVO.setIp(OswIpSettingBriefOpenApiVO.buildOswIpSettingBriefOpenApiVO(lanNetworkVO.getIp()));
        openApiVO.setMode(lanNetworkVO.getMode());
        openApiVO.setDhcpServer(OswNetworkOpenApiVO.buildOswDhcpServerOpenApiVO(lanNetworkVO.getDhcpServer()));
        openApiVO.setDhcpRelay(OswNetworkOpenApiVO.buildOswDhcpRelayOpenApiVO(lanNetworkVO.getDhcpRelay()));
        openApiVO.setTotalIpNum(lanNetworkVO.getTotalIpNum());
        openApiVO.setDhcpServerNum(lanNetworkVO.getDhcpServerNum());
        openApiVO.setSubnetOverrideEnable(lanNetworkVO.getSubnetOverrideEnable());
        openApiVO.setSubnetOverride(lanNetworkVO.getSubnetOverride());
        return openApiVO;
    }

    private static Integer buildPurpose(String purposeVO) {
        if (T.a((String)purposeVO)) {
            return null;
        }
        switch (purposeVO) {
            case "vlan": {
                return 0;
            }
            case "interface": {
                return 1;
            }
        }
        return null;
    }

    private static LanNetworkIpv6ConfigTemplateOpenApiVO buildLanNetworkIpv6Config(LanNetworkIpv6ConfigVO lanNetworkIpv6Config) {
        if (Objects.isNull(lanNetworkIpv6Config)) {
            return null;
        }
        LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6ConfigOpenApiVO = new LanNetworkIpv6ConfigTemplateOpenApiVO();
        lanNetworkIpv6ConfigOpenApiVO.setProto(LanNetworkTemplateQueryOpenApiV3VO.buildProto(lanNetworkIpv6Config.getProto()));
        lanNetworkIpv6ConfigOpenApiVO.setEnable(lanNetworkIpv6Config.getEnable());
        lanNetworkIpv6ConfigOpenApiVO.setDhcpv6(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpv6(lanNetworkIpv6Config.getDhcpv6()));
        lanNetworkIpv6ConfigOpenApiVO.setSlaac(LanNetworkTemplateQueryOpenApiV3VO.buildSlaacOpenApiVO(lanNetworkIpv6Config.getSlaac()));
        lanNetworkIpv6ConfigOpenApiVO.setRdnss(LanNetworkTemplateQueryOpenApiV3VO.buildSlaacOpenApiVO(lanNetworkIpv6Config.getRdnss()));
        lanNetworkIpv6ConfigOpenApiVO.setRa(LanNetworkTemplateQueryOpenApiV3VO.buildRa(lanNetworkIpv6Config.getRa()));
        return lanNetworkIpv6ConfigOpenApiVO;
    }

    private static Integer buildProto(String proto) {
        if (T.a((String)proto)) {
            return 0;
        }
        switch (proto) {
            case "dhcpv6": {
                return 1;
            }
            case "slaac": {
                return 2;
            }
            case "rdnss": {
                return 3;
            }
            case "passthrough": {
                return 4;
            }
        }
        return 0;
    }

    private static RouteAdvertisementOpenApiVO buildRa(RouteAdvertisementVO ra) {
        if (Objects.isNull(ra)) {
            return null;
        }
        RouteAdvertisementOpenApiVO routeAdvertisementOpenApiVO = new RouteAdvertisementOpenApiVO();
        routeAdvertisementOpenApiVO.setEnable(ra.getEnable());
        routeAdvertisementOpenApiVO.setPreference(ra.getPreference());
        routeAdvertisementOpenApiVO.setValidLifetime(ra.getValidLifetime());
        routeAdvertisementOpenApiVO.setPreferredLifetime(ra.getPreferredLifetime());
        return routeAdvertisementOpenApiVO;
    }

    private static SlaacTemplateOpenApiVO buildSlaacOpenApiVO(SlaacVO slaac) {
        if (Objects.isNull(slaac)) {
            return null;
        }
        SlaacTemplateOpenApiVO slaacOpenApiVO = new SlaacTemplateOpenApiVO();
        slaacOpenApiVO.setPrefix(slaac.getPrefix());
        slaacOpenApiVO.setPreId(slaac.getPreId());
        slaacOpenApiVO.setDnsv6(LanNetworkTemplateQueryOpenApiV3VO.buildDnsv6(slaac.getDnsv6()));
        slaacOpenApiVO.setPriDns(slaac.getPriDns());
        slaacOpenApiVO.setSndDns(slaac.getSndDns());
        return slaacOpenApiVO;
    }

    private static Integer buildDnsv6(String dnsv6) {
        if (T.a((String)dnsv6)) {
            return null;
        }
        switch (dnsv6) {
            case "auto": {
                return 0;
            }
            case "manual": {
                return 1;
            }
        }
        return null;
    }

    private static Dhcpv6OpenApiVO buildDhcpv6(Dhcpv6VO dhcpv6) {
        if (Objects.isNull(dhcpv6)) {
            return null;
        }
        Dhcpv6OpenApiVO dhcpv6OpenApiVO = new Dhcpv6OpenApiVO();
        dhcpv6OpenApiVO.setGateway(dhcpv6.getGateway());
        dhcpv6OpenApiVO.setSubnet(dhcpv6.getSubnet());
        dhcpv6OpenApiVO.setIpaddrStart(dhcpv6.getIpaddrStart());
        dhcpv6OpenApiVO.setIpaddrEnd(dhcpv6.getIpaddrEnd());
        dhcpv6OpenApiVO.setLeasetime(dhcpv6.getLeasetime());
        dhcpv6OpenApiVO.setDnsv6(LanNetworkTemplateQueryOpenApiV3VO.buildDnsv6(dhcpv6.getDnsv6()));
        dhcpv6OpenApiVO.setPriDns(dhcpv6.getPriDns());
        dhcpv6OpenApiVO.setSndDns(dhcpv6.getSndDns());
        return dhcpv6OpenApiVO;
    }

    private static DhcpGuardOpenApiVO buildDhcpGuard(DhcpGuardVO dhcpGuard) {
        if (Objects.isNull(dhcpGuard)) {
            return null;
        }
        DhcpGuardOpenApiVO dhcpGuardOpenApiVO = new DhcpGuardOpenApiVO();
        dhcpGuardOpenApiVO.setEnable(dhcpGuard.getEnable());
        dhcpGuardOpenApiVO.setDhcpSvr1(dhcpGuard.getDhcpSvr1());
        dhcpGuardOpenApiVO.setDhcpSvr2(dhcpGuard.getDhcpSvr2());
        return dhcpGuardOpenApiVO;
    }

    private static Dhcpv6GuardOpenApiVO buildDhcpv6Guard(Dhcpv6GuardVO dhcpv6Guard) {
        if (Objects.isNull(dhcpv6Guard)) {
            return null;
        }
        Dhcpv6GuardOpenApiVO dhcpv6GuardOpenApiVO = new Dhcpv6GuardOpenApiVO();
        dhcpv6GuardOpenApiVO.setEnable(dhcpv6Guard.getEnable());
        dhcpv6GuardOpenApiVO.setDhcpv6Svr1(dhcpv6Guard.getDhcpv6Svr1());
        dhcpv6GuardOpenApiVO.setDhcpv6Svr2(dhcpv6Guard.getDhcpv6Svr2());
        return dhcpv6GuardOpenApiVO;
    }

    private static DhcpSettingsTemplateOpenApiVO buildDhcpSettingsVO(DhcpSettingsVO dhcpSettings) {
        if (Objects.isNull(dhcpSettings)) {
            return null;
        }
        DhcpSettingsTemplateOpenApiVO dhcpSettingsOpenApiVO = new DhcpSettingsTemplateOpenApiVO();
        dhcpSettingsOpenApiVO.setEnable(dhcpSettings.getEnable());
        dhcpSettingsOpenApiVO.setIpRangePool(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpRangeOpenApiVO(dhcpSettings.getIpRangePool()));
        dhcpSettingsOpenApiVO.setIpRangeStart(dhcpSettings.getIpRangeStart());
        dhcpSettingsOpenApiVO.setIpRangeEnd(dhcpSettings.getIpRangeEnd());
        dhcpSettingsOpenApiVO.setDhcpns(dhcpSettings.getDhcpns());
        dhcpSettingsOpenApiVO.setPriDns(dhcpSettings.getPriDns());
        dhcpSettingsOpenApiVO.setSndDns(dhcpSettings.getSndDns());
        dhcpSettingsOpenApiVO.setLeasetime(dhcpSettings.getLeasetime());
        dhcpSettingsOpenApiVO.setGateway(dhcpSettings.getGateway());
        dhcpSettingsOpenApiVO.setDhcpNextServer(dhcpSettings.getDhcpNextServer());
        dhcpSettingsOpenApiVO.setOptions(LanNetworkTemplateQueryOpenApiV3VO.buildDhcpOptions(dhcpSettings.getOptions()));
        return dhcpSettingsOpenApiVO;
    }

    private static List<DhcpRangeOpenApiVO> buildDhcpRangeOpenApiVO(List<DhcpRangeVO> ipRangePools) {
        if (ipRangePools == null) {
            return null;
        }
        return ipRangePools.stream().map(dhcpRangeVO -> new DhcpRangeOpenApiVO().setIpaddrStart(dhcpRangeVO.getIpaddrStart()).setIpaddrEnd(dhcpRangeVO.getIpaddrEnd())).collect(Collectors.toList());
    }

    private static List<DhcpOptionOpenApiVO> buildDhcpOptions(List<DhcpOptionVO> options) {
        if (CollectionUtils.isEmpty(options)) {
            return Collections.emptyList();
        }
        ArrayList<DhcpOptionOpenApiVO> dhcpOptions = new ArrayList<DhcpOptionOpenApiVO>();
        options.forEach(vo -> {
            DhcpOptionOpenApiVO openApiVO = new DhcpOptionOpenApiVO();
            openApiVO.setCode(vo.getCode());
            openApiVO.setType(vo.getType());
            openApiVO.setValue(vo.getValue());
            dhcpOptions.add(openApiVO);
        });
        return dhcpOptions;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPurpose() {
        return this.purpose;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public Boolean getIsolation() {
        return this.isolation;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public String getGatewaySubnet() {
        return this.gatewaySubnet;
    }

    @Generated
    public DhcpSettingsTemplateOpenApiVO getDhcpSettings() {
        return this.dhcpSettings;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Dhcpv6GuardOpenApiVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardOpenApiVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Boolean getPortal() {
        return this.portal;
    }

    @Generated
    public String getPortalId() {
        return this.portalId;
    }

    @Generated
    public String getPortalName() {
        return this.portalName;
    }

    @Generated
    public Boolean getAccessControlRule() {
        return this.accessControlRule;
    }

    @Generated
    public Boolean getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public LanNetworkIpv6ConfigTemplateOpenApiVO getLanNetworkIpv6Config() {
        return this.lanNetworkIpv6Config;
    }

    @Generated
    public Boolean getAllLan() {
        return this.allLan;
    }

    @Generated
    public String getOrigName() {
        return this.origName;
    }

    @Generated
    public Boolean getArpDetectionEnable() {
        return this.arpDetectionEnable;
    }

    @Generated
    public Boolean getQosQueueEnable() {
        return this.qosQueueEnable;
    }

    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public Boolean getExistMultiVlan() {
        return this.existMultiVlan;
    }

    @Generated
    public Boolean getExistRA() {
        return this.existRA;
    }

    @Generated
    public Boolean getExistCustomDhcpOption() {
        return this.existCustomDhcpOption;
    }

    @Generated
    public Boolean getExistDhcpNextServer() {
        return this.existDhcpNextServer;
    }

    @Generated
    public Boolean getExistArpDetection() {
        return this.existArpDetection;
    }

    @Generated
    public Boolean getExistNetworkIsolation() {
        return this.existNetworkIsolation;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public OswIpSettingBriefOpenApiVO getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public OswDhcpServerOpenApiVO getDhcpServer() {
        return this.dhcpServer;
    }

    @Generated
    public OswDhcpRelayOpenApiVO getDhcpRelay() {
        return this.dhcpRelay;
    }

    @Generated
    public Long getTotalIpNum() {
        return this.totalIpNum;
    }

    @Generated
    public Integer getDhcpServerNum() {
        return this.dhcpServerNum;
    }

    @Generated
    public Boolean getSubnetOverrideEnable() {
        return this.subnetOverrideEnable;
    }

    @Generated
    public Boolean getSubnetOverride() {
        return this.subnetOverride;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="primary")
    @Generated
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
    }

    @Generated
    public void setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
    }

    @Generated
    public void setVlans(String vlans) {
        this.vlans = vlans;
    }

    @Generated
    public void setApplication(Integer application) {
        this.application = application;
    }

    @Generated
    public void setIsolation(Boolean isolation) {
        this.isolation = isolation;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setGatewaySubnet(String gatewaySubnet) {
        this.gatewaySubnet = gatewaySubnet;
    }

    @Generated
    public void setDhcpSettings(DhcpSettingsTemplateOpenApiVO dhcpSettings) {
        this.dhcpSettings = dhcpSettings;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
    }

    @Generated
    public void setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
    }

    @Generated
    public void setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
    }

    @Generated
    public void setDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
    }

    @Generated
    public void setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
    }

    @Generated
    public void setDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
    }

    @Generated
    public void setPortal(Boolean portal) {
        this.portal = portal;
    }

    @Generated
    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }

    @Generated
    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    @Generated
    public void setAccessControlRule(Boolean accessControlRule) {
        this.accessControlRule = accessControlRule;
    }

    @Generated
    public void setRateLimit(Boolean rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setLanNetworkIpv6Config(LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config) {
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
    }

    @Generated
    public void setAllLan(Boolean allLan) {
        this.allLan = allLan;
    }

    @Generated
    public void setOrigName(String origName) {
        this.origName = origName;
    }

    @Generated
    public void setArpDetectionEnable(Boolean arpDetectionEnable) {
        this.arpDetectionEnable = arpDetectionEnable;
    }

    @Generated
    public void setQosQueueEnable(Boolean qosQueueEnable) {
        this.qosQueueEnable = qosQueueEnable;
    }

    @Generated
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    @Generated
    public void setExistMultiVlan(Boolean existMultiVlan) {
        this.existMultiVlan = existMultiVlan;
    }

    @Generated
    public void setExistRA(Boolean existRA) {
        this.existRA = existRA;
    }

    @Generated
    public void setExistCustomDhcpOption(Boolean existCustomDhcpOption) {
        this.existCustomDhcpOption = existCustomDhcpOption;
    }

    @Generated
    public void setExistDhcpNextServer(Boolean existDhcpNextServer) {
        this.existDhcpNextServer = existDhcpNextServer;
    }

    @Generated
    public void setExistArpDetection(Boolean existArpDetection) {
        this.existArpDetection = existArpDetection;
    }

    @Generated
    public void setExistNetworkIsolation(Boolean existNetworkIsolation) {
        this.existNetworkIsolation = existNetworkIsolation;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setIp(OswIpSettingBriefOpenApiVO ip) {
        this.ip = ip;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setDhcpServer(OswDhcpServerOpenApiVO dhcpServer) {
        this.dhcpServer = dhcpServer;
    }

    @Generated
    public void setDhcpRelay(OswDhcpRelayOpenApiVO dhcpRelay) {
        this.dhcpRelay = dhcpRelay;
    }

    @Generated
    public void setTotalIpNum(Long totalIpNum) {
        this.totalIpNum = totalIpNum;
    }

    @Generated
    public void setDhcpServerNum(Integer dhcpServerNum) {
        this.dhcpServerNum = dhcpServerNum;
    }

    @Generated
    public void setSubnetOverrideEnable(Boolean subnetOverrideEnable) {
        this.subnetOverrideEnable = subnetOverrideEnable;
    }

    @Generated
    public void setSubnetOverride(Boolean subnetOverride) {
        this.subnetOverride = subnetOverride;
    }

    @Generated
    public String toString() {
        return "LanNetworkTemplateQueryOpenApiV3VO(id=" + this.getId() + ", primary=" + this.getPrimary() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", interfaceIds=" + this.getInterfaceIds() + ", vlanType=" + this.getVlanType() + ", vlans=" + this.getVlans() + ", application=" + this.getApplication() + ", isolation=" + this.getIsolation() + ", vlan=" + this.getVlan() + ", gatewaySubnet=" + this.getGatewaySubnet() + ", dhcpSettings=" + this.getDhcpSettings() + ", domain=" + this.getDomain() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", portal=" + this.getPortal() + ", portalId=" + this.getPortalId() + ", portalName=" + this.getPortalName() + ", accessControlRule=" + this.getAccessControlRule() + ", rateLimit=" + this.getRateLimit() + ", lanNetworkIpv6Config=" + this.getLanNetworkIpv6Config() + ", allLan=" + this.getAllLan() + ", origName=" + this.getOrigName() + ", arpDetectionEnable=" + this.getArpDetectionEnable() + ", qosQueueEnable=" + this.getQosQueueEnable() + ", queueId=" + this.getQueueId() + ", existMultiVlan=" + this.getExistMultiVlan() + ", existRA=" + this.getExistRA() + ", existCustomDhcpOption=" + this.getExistCustomDhcpOption() + ", existDhcpNextServer=" + this.getExistDhcpNextServer() + ", existArpDetection=" + this.getExistArpDetection() + ", existNetworkIsolation=" + this.getExistNetworkIsolation() + ", deviceType=" + this.getDeviceType() + ", deviceMac=" + this.getDeviceMac() + ", stackId=" + this.getStackId() + ", ip=" + this.getIp() + ", mode=" + this.getMode() + ", dhcpServer=" + this.getDhcpServer() + ", dhcpRelay=" + this.getDhcpRelay() + ", totalIpNum=" + this.getTotalIpNum() + ", dhcpServerNum=" + this.getDhcpServerNum() + ", subnetOverrideEnable=" + this.getSubnetOverrideEnable() + ", subnetOverride=" + this.getSubnetOverride() + ")";
    }

    @Generated
    public LanNetworkTemplateQueryOpenApiV3VO(String id, Boolean primary, String name, Integer purpose, List<String> interfaceIds, Integer vlanType, String vlans, Integer application, Boolean isolation, Integer vlan, String gatewaySubnet, DhcpSettingsTemplateOpenApiVO dhcpSettings, String domain, Boolean igmpSnoopEnable, Boolean fastLeaveEnable, Boolean mldSnoopEnable, Dhcpv6GuardOpenApiVO dhcpv6Guard, Boolean dhcpL2RelayEnable, DhcpGuardOpenApiVO dhcpGuard, Boolean portal, String portalId, String portalName, Boolean accessControlRule, Boolean rateLimit, LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config, Boolean allLan, String origName, Boolean arpDetectionEnable, Boolean qosQueueEnable, Integer queueId, Boolean existMultiVlan, Boolean existRA, Boolean existCustomDhcpOption, Boolean existDhcpNextServer, Boolean existArpDetection, Boolean existNetworkIsolation, Integer deviceType, String deviceMac, String stackId, OswIpSettingBriefOpenApiVO ip, Integer mode, OswDhcpServerOpenApiVO dhcpServer, OswDhcpRelayOpenApiVO dhcpRelay, Long totalIpNum, Integer dhcpServerNum, Boolean subnetOverrideEnable, Boolean subnetOverride) {
        this.id = id;
        this.primary = primary;
        this.name = name;
        this.purpose = purpose;
        this.interfaceIds = interfaceIds;
        this.vlanType = vlanType;
        this.vlans = vlans;
        this.application = application;
        this.isolation = isolation;
        this.vlan = vlan;
        this.gatewaySubnet = gatewaySubnet;
        this.dhcpSettings = dhcpSettings;
        this.domain = domain;
        this.igmpSnoopEnable = igmpSnoopEnable;
        this.fastLeaveEnable = fastLeaveEnable;
        this.mldSnoopEnable = mldSnoopEnable;
        this.dhcpv6Guard = dhcpv6Guard;
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        this.dhcpGuard = dhcpGuard;
        this.portal = portal;
        this.portalId = portalId;
        this.portalName = portalName;
        this.accessControlRule = accessControlRule;
        this.rateLimit = rateLimit;
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
        this.allLan = allLan;
        this.origName = origName;
        this.arpDetectionEnable = arpDetectionEnable;
        this.qosQueueEnable = qosQueueEnable;
        this.queueId = queueId;
        this.existMultiVlan = existMultiVlan;
        this.existRA = existRA;
        this.existCustomDhcpOption = existCustomDhcpOption;
        this.existDhcpNextServer = existDhcpNextServer;
        this.existArpDetection = existArpDetection;
        this.existNetworkIsolation = existNetworkIsolation;
        this.deviceType = deviceType;
        this.deviceMac = deviceMac;
        this.stackId = stackId;
        this.ip = ip;
        this.mode = mode;
        this.dhcpServer = dhcpServer;
        this.dhcpRelay = dhcpRelay;
        this.totalIpNum = totalIpNum;
        this.dhcpServerNum = dhcpServerNum;
        this.subnetOverrideEnable = subnetOverrideEnable;
        this.subnetOverride = subnetOverride;
    }

    @Generated
    public LanNetworkTemplateQueryOpenApiV3VO() {
    }
}

