/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="LanNetworkSplitOpenApiVO")
public class LanNetworkSplitOpenApiVO {
    @Schema(name="id", description="LAN network ID")
    private String id;
    @JsonProperty(value="primary")
    @Schema(name="primary", description="Primary")
    private Boolean primary;
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters") String name;
    @Range(min=0L, max=1L)
    @Schema(name="vlanType", description="When purpose is interface, VLANType should be a value as follows: 0: Single; 1: Multiple")
    private @Range(min=0L, max=1L) Integer vlanType;
    @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.")
    @Schema(name="vlan", description="Vlan should be within the range of 1-4090.")
    private @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.") Integer vlan;

    public static LanNetworkSplitOpenApiVO buildByWebVO(LanNetworkVO lanNetworkVO) {
        LanNetworkSplitOpenApiVO openApiVO = new LanNetworkSplitOpenApiVO();
        openApiVO.setId(lanNetworkVO.getId());
        openApiVO.setPrimary(lanNetworkVO.getPrimary());
        openApiVO.setName(lanNetworkVO.getName());
        openApiVO.setVlanType(lanNetworkVO.getVlanType());
        openApiVO.setVlan(lanNetworkVO.getVlan());
        return openApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="primary")
    @Generated
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public String toString() {
        return "LanNetworkSplitOpenApiVO(id=" + this.getId() + ", primary=" + this.getPrimary() + ", name=" + this.getName() + ", vlanType=" + this.getVlanType() + ", vlan=" + this.getVlan() + ")";
    }

    @Generated
    public LanNetworkSplitOpenApiVO(String id, Boolean primary, String name, Integer vlanType, Integer vlan) {
        this.id = id;
        this.primary = primary;
        this.name = name;
        this.vlanType = vlanType;
        this.vlan = vlan;
    }

    @Generated
    public LanNetworkSplitOpenApiVO() {
    }
}

