/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.OswIpSettingBriefOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpGuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpRangeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6GuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.LanNetworkIpv6ConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PassthroughOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.RouteAdvertisementOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.SlaacOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DhcpSettingsConfigOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpRelayOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswNetworkOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpOptionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpRangeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpSettingsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.PassthroughVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.RouteAdvertisementVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.SlaacVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(description="LANNetworkOpenApiVO")
public class LanNetworkOpenApiV3VO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @Range(min=0L, max=1L)
    @Schema(name="vlanType", description="VLANType should be a value as follows: 0: Single; 1: Multiple")
    private @Range(min=0L, max=1L) Integer vlanType;
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    @Schema(name="vlans", description="Only valid when vlanType is 1 and device type is 0 , 1 or 3. When device type is 0 or 3, batch create single vlan, when deviceType is 1 , create bridge vlan. VLAN format: 200, 1-100.")
    private @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.")
    @Schema(name="vlan", description="Only Valid when vlanType is 0. When deviceType is 1, vlan should be within the range of 1-4090.When deviceType is 0 , 2 or 3, vlan could be within the range of 1-4094.")
    private @Range(min=1L, max=4094L, message="Value of vlan is from 1 to 4094.") Integer vlan;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.")
    @Schema(name="gatewaySubnet", description="When deviceType is 1, gateway subnet is needed. Format: IP/Mask")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.") String gatewaySubnet;
    @Valid
    @Schema(name="dhcpSettings", description="Configure DHCP settings")
    private DhcpSettingsConfigOpenApiV2VO dhcpSettings;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    @Schema(name="domain", description="The domain of this network")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domain;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    @Schema(name="igmpSnoopEnable", description="Enable IGMP snooping")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    @Schema(name="mldSnoopEnable", description="Enable MLD snooping")
    private Boolean mldSnoopEnable;
    @Schema(name="dhcpL2RelayEnable", description="The switch of DHCP L2 relay")
    private Boolean dhcpL2RelayEnable;
    @Valid
    @Schema(name="dhcpGuard", description="Legal DHCP Server")
    private DhcpGuardOpenApiVO dhcpGuard;
    @Schema(name="dhcpv6Guard", description="Legal DHCPv6 Server")
    private Dhcpv6GuardOpenApiVO dhcpv6Guard;
    @Valid
    @Schema(name="lanNetworkIpv6Config", description="LAN network IPv6 config")
    private LanNetworkIpv6ConfigOpenApiVO lanNetworkIpv6Config;
    @Schema(name="arpDetectionEnable", description="Enable arp detection. Only valid when deviceType is 1 and gateway supports this feature.")
    private Boolean arpDetectionEnable;
    @Schema(name="isolation", description="Whether network isolated.")
    private Boolean isolation;
    @Schema(name="qosQueueEnable", description="The switch of QoS queue.")
    private Boolean qosQueueEnable;
    @Schema(name="queueId", description="QoS queue Id.")
    private Integer queueId;
    @NotNull(message="Parameter [deviceType] should not be null.")
    @Schema(name="deviceType", description="DHCP Server Device type. It should be a value as follows: 0:External Device 1:gateway 2:switch 3:none")
    private @NotNull(message="Parameter [deviceType] should not be null.") Integer deviceType;
    @Schema(name="deviceMac", description="DHCP Server Device mac. Only valid when deviceType is 1 or 2. When deviceType is 1, deviceMac can be empty when there is no gateway in the site.")
    @a
    private String deviceMac;
    @Schema(name="stackId", description="DHCP Server Device stackId. Only valid when deviceType is 2 and the selected device is stack")
    private String stackId;
    @Valid
    @Schema(name="ip", description="Network IP setting. Only valid when deviceType is 2.")
    private OswIpSettingBriefOpenApiVO ip;
    @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.")
    @Schema(name="mode", description="DHCP mode. 0: None 1: DHCP Server 2: DHCP Relay. Only valid when deviceType is 2.")
    private @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.") Integer mode;
    @Schema(name="vrfId", description="VRF ID")
    private String vrfId;
    @Valid
    @Schema(name="dhcpServer", description="Network DHCP server settings. Only valid when deviceType is 2 and mode is 1.")
    private OswDhcpServerOpenApiVO dhcpServer;
    @Valid
    @Schema(name="dhcpRelay", description="Network DHCP relay settings. Only valid when deviceType is 2 and mode is 2")
    private OswDhcpRelayOpenApiVO dhcpRelay;
    @Schema(name="subnetOverrideEnable", description="The switch status of DHCP Settings Overrides.")
    private Boolean subnetOverrideEnable;

    public static LanNetworkVO toLanNetworkVO(LanNetworkOpenApiV3VO lanNetworkOpenApiVO) {
        if (Objects.isNull(lanNetworkOpenApiVO)) {
            return null;
        }
        LanNetworkVO lanNetworkVO = new LanNetworkVO();
        lanNetworkVO.setName(lanNetworkOpenApiVO.getName());
        lanNetworkVO.setVlanType(lanNetworkOpenApiVO.getVlanType());
        lanNetworkVO.setVlans(lanNetworkOpenApiVO.getVlans());
        lanNetworkVO.setVlan(lanNetworkOpenApiVO.getVlan());
        lanNetworkVO.setGatewaySubnet(lanNetworkOpenApiVO.getGatewaySubnet());
        lanNetworkVO.setDhcpSettings(LanNetworkOpenApiV3VO.toDhcpSettings(lanNetworkOpenApiVO.getDhcpSettings()));
        lanNetworkVO.setDomain(lanNetworkOpenApiVO.getDomain());
        lanNetworkVO.setIgmpSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getIgmpSnoopEnable())));
        lanNetworkVO.setMldSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getMldSnoopEnable())));
        lanNetworkVO.setDhcpv6Guard(LanNetworkOpenApiV3VO.toDhcpv6Guard(lanNetworkOpenApiVO.getDhcpv6Guard()));
        lanNetworkVO.setDhcpL2RelayEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getDhcpL2RelayEnable())));
        lanNetworkVO.setDhcpGuard(LanNetworkOpenApiV3VO.toDhcpGuard(lanNetworkOpenApiVO.getDhcpGuard()));
        lanNetworkVO.setLanNetworkIpv6Config(LanNetworkOpenApiV3VO.toLanNetworkIpv6Config(lanNetworkOpenApiVO.getLanNetworkIpv6Config()));
        lanNetworkVO.setArpDetectionEnable(lanNetworkOpenApiVO.getArpDetectionEnable());
        lanNetworkVO.setIsolation(lanNetworkOpenApiVO.getIsolation());
        lanNetworkVO.setQosQueueEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getQosQueueEnable())));
        lanNetworkVO.setQueueId(lanNetworkOpenApiVO.getQueueId());
        lanNetworkVO.setDeviceType(lanNetworkOpenApiVO.getDeviceType());
        lanNetworkVO.setDeviceMac(lanNetworkOpenApiVO.getDeviceMac());
        lanNetworkVO.setStackId(lanNetworkOpenApiVO.getStackId());
        lanNetworkVO.setIp(OswIpSettingBriefOpenApiVO.buildOswIpSettingVO(lanNetworkOpenApiVO.getIp()));
        lanNetworkVO.setMode(lanNetworkOpenApiVO.getMode());
        lanNetworkVO.setVrfId(lanNetworkOpenApiVO.getVrfId());
        lanNetworkVO.setDhcpServer(OswNetworkOpenApiVO.buildOswDhcpServerWebVO(lanNetworkOpenApiVO.getDhcpServer()));
        lanNetworkVO.setDhcpRelay(OswNetworkOpenApiVO.buildOswDhcpRelayWebVO(lanNetworkOpenApiVO.getDhcpRelay()));
        lanNetworkVO.setSubnetOverrideEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getSubnetOverrideEnable())));
        return lanNetworkVO;
    }

    private static LanNetworkIpv6ConfigVO toLanNetworkIpv6Config(LanNetworkIpv6ConfigOpenApiVO lanNetworkIpv6Config) {
        if (Objects.isNull(lanNetworkIpv6Config)) {
            LanNetworkIpv6ConfigVO lanNetworkIpv6ConfigVO = new LanNetworkIpv6ConfigVO();
            lanNetworkIpv6ConfigVO.setEnable(Integer.valueOf(0));
            lanNetworkIpv6ConfigVO.setProto("none");
            lanNetworkIpv6ConfigVO.setRdnss(LanNetworkOpenApiV3VO.toSlaacVO(null));
            lanNetworkIpv6ConfigVO.setSlaac(LanNetworkOpenApiV3VO.toSlaacVO(null));
            return lanNetworkIpv6ConfigVO;
        }
        LanNetworkIpv6ConfigVO lanNetworkIpv6ConfigVO = new LanNetworkIpv6ConfigVO();
        lanNetworkIpv6ConfigVO.setProto(LanNetworkOpenApiV3VO.toProto(lanNetworkIpv6Config.getProto()));
        lanNetworkIpv6ConfigVO.setEnable(Integer.valueOf(lanNetworkIpv6Config.getEnable() == null ? 0 : lanNetworkIpv6Config.getEnable()));
        lanNetworkIpv6ConfigVO.setDhcpv6(LanNetworkOpenApiV3VO.toDhcpv6(lanNetworkIpv6Config.getDhcpv6()));
        lanNetworkIpv6ConfigVO.setSlaac(LanNetworkOpenApiV3VO.toSlaacVO(lanNetworkIpv6Config.getSlaac()));
        lanNetworkIpv6ConfigVO.setRdnss(LanNetworkOpenApiV3VO.toSlaacVO(lanNetworkIpv6Config.getRdnss()));
        lanNetworkIpv6ConfigVO.setPassthrough(LanNetworkOpenApiV3VO.toPassthrough(lanNetworkIpv6Config.getPassthrough()));
        lanNetworkIpv6ConfigVO.setRa(LanNetworkOpenApiV3VO.toRouteAdvertisement(lanNetworkIpv6Config.getRa()));
        return lanNetworkIpv6ConfigVO;
    }

    private static String toProto(Integer proto) {
        if (Objects.isNull(proto)) {
            return "none";
        }
        switch (proto) {
            case 1: {
                return "dhcpv6";
            }
            case 2: {
                return "slaac";
            }
            case 3: {
                return "rdnss";
            }
            case 4: {
                return "passthrough";
            }
        }
        return "none";
    }

    private static RouteAdvertisementVO toRouteAdvertisement(RouteAdvertisementOpenApiVO ra) {
        if (Objects.isNull(ra)) {
            return null;
        }
        RouteAdvertisementVO routeAdvertisementVO = new RouteAdvertisementVO();
        routeAdvertisementVO.setEnable(ra.getEnable());
        routeAdvertisementVO.setPreference(ra.getPreference());
        routeAdvertisementVO.setValidLifetime(ra.getValidLifetime());
        routeAdvertisementVO.setPreferredLifetime(ra.getPreferredLifetime());
        return routeAdvertisementVO;
    }

    private static PassthroughVO toPassthrough(PassthroughOpenApiVO passthrough) {
        if (Objects.isNull(passthrough)) {
            return null;
        }
        PassthroughVO passthroughVO = new PassthroughVO();
        passthroughVO.setPortUuid(passthrough.getPortId());
        return passthroughVO;
    }

    private static SlaacVO toSlaacVO(SlaacOpenApiVO slaac) {
        if (Objects.isNull(slaac)) {
            SlaacVO slaacVO = new SlaacVO();
            slaacVO.setPreType(Integer.valueOf(0));
            return slaacVO;
        }
        SlaacVO slaacVO = new SlaacVO();
        slaacVO.setPreType(slaac.getPreType());
        slaacVO.setPrefix(slaac.getPrefix());
        slaacVO.setPortUuid(slaac.getPortUuid());
        slaacVO.setPreId(slaac.getPreId());
        slaacVO.setDnsv6(LanNetworkOpenApiV3VO.toDnsv6(slaac.getDnsv6()));
        slaacVO.setPriDns(slaac.getPriDns());
        slaacVO.setSndDns(slaac.getSndDns());
        return slaacVO;
    }

    private static String toDnsv6(Integer dnsv6) {
        if (Objects.isNull(dnsv6)) {
            return null;
        }
        switch (dnsv6) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "manual";
            }
        }
        return null;
    }

    private static Dhcpv6VO toDhcpv6(Dhcpv6OpenApiVO dhcpv6) {
        if (Objects.isNull(dhcpv6)) {
            return null;
        }
        Dhcpv6VO dhcpv6VO = new Dhcpv6VO();
        dhcpv6VO.setGateway(dhcpv6.getGateway());
        dhcpv6VO.setSubnet(dhcpv6.getSubnet());
        dhcpv6VO.setIpaddrStart(dhcpv6.getIpaddrStart());
        dhcpv6VO.setIpaddrEnd(dhcpv6.getIpaddrEnd());
        dhcpv6VO.setLeasetime(dhcpv6.getLeasetime());
        dhcpv6VO.setDnsv6(LanNetworkOpenApiV3VO.toDnsv6(dhcpv6.getDnsv6()));
        dhcpv6VO.setPriDns(dhcpv6.getPriDns());
        dhcpv6VO.setSndDns(dhcpv6.getSndDns());
        return dhcpv6VO;
    }

    private static DhcpGuardVO toDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        if (Objects.isNull(dhcpGuard)) {
            DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
            dhcpGuardVO.setEnable(Boolean.valueOf(false));
            return dhcpGuardVO;
        }
        DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
        dhcpGuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpGuard.getEnable())));
        dhcpGuardVO.setDhcpSvr1(dhcpGuard.getDhcpSvr1());
        dhcpGuardVO.setDhcpSvr2(dhcpGuard.getDhcpSvr2());
        return dhcpGuardVO;
    }

    private static Dhcpv6GuardVO toDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        if (Objects.isNull(dhcpv6Guard)) {
            Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
            dhcpv6GuardVO.setEnable(Boolean.valueOf(false));
            return dhcpv6GuardVO;
        }
        Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
        dhcpv6GuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpv6Guard.getEnable())));
        dhcpv6GuardVO.setDhcpv6Svr1(dhcpv6Guard.getDhcpv6Svr1());
        dhcpv6GuardVO.setDhcpv6Svr2(dhcpv6Guard.getDhcpv6Svr2());
        return dhcpv6GuardVO;
    }

    private static DhcpSettingsVO toDhcpSettings(DhcpSettingsConfigOpenApiV2VO dhcpSettingsVO) {
        if (Objects.isNull(dhcpSettingsVO)) {
            DhcpSettingsVO dhcpSettings = new DhcpSettingsVO();
            dhcpSettings.setEnable(Boolean.valueOf(false));
            return dhcpSettings;
        }
        DhcpSettingsVO dhcpSettings = new DhcpSettingsVO();
        dhcpSettings.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpSettingsVO.getEnable())));
        dhcpSettings.setIpRangePool(LanNetworkOpenApiV3VO.buildDhcpRangeVO(dhcpSettingsVO.getIpRangePool()));
        dhcpSettings.setDhcpns(dhcpSettingsVO.getDhcpns());
        dhcpSettings.setPriDns(dhcpSettingsVO.getPriDns());
        dhcpSettings.setSndDns(dhcpSettingsVO.getSndDns());
        dhcpSettings.setLeasetime(dhcpSettingsVO.getLeasetime());
        dhcpSettings.setGateway(dhcpSettingsVO.getGateway());
        dhcpSettings.setDhcpNextServer(dhcpSettingsVO.getDhcpNextServer());
        dhcpSettings.setOptions(LanNetworkOpenApiV3VO.toOptions(dhcpSettingsVO.getOptions()));
        return dhcpSettings;
    }

    private static List<DhcpRangeVO> buildDhcpRangeVO(List<DhcpRangeOpenApiVO> dhcpRangeOpenApiVOs) {
        if (dhcpRangeOpenApiVOs == null) {
            return null;
        }
        return dhcpRangeOpenApiVOs.stream().map(dhcpRangeOpenApiVO -> new DhcpRangeVO().setIpaddrStart(dhcpRangeOpenApiVO.getIpaddrStart()).setIpaddrEnd(dhcpRangeOpenApiVO.getIpaddrEnd())).collect(Collectors.toList());
    }

    private static List<DhcpOptionVO> toOptions(List<DhcpOptionOpenApiVO> openApiOptions) {
        if (CollectionUtils.isEmpty(openApiOptions)) {
            return Collections.emptyList();
        }
        ArrayList<DhcpOptionVO> dhcpOptionVOList = new ArrayList<DhcpOptionVO>();
        openApiOptions.forEach(dhcpOptionOpenApiVO -> {
            DhcpOptionVO dhcpOptionVO = new DhcpOptionVO();
            dhcpOptionVO.setCode(dhcpOptionOpenApiVO.getCode());
            dhcpOptionVO.setType(dhcpOptionOpenApiVO.getType());
            dhcpOptionVO.setValue(dhcpOptionOpenApiVO.getValue());
            dhcpOptionVOList.add(dhcpOptionVO);
        });
        return dhcpOptionVOList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public String getGatewaySubnet() {
        return this.gatewaySubnet;
    }

    @Generated
    public DhcpSettingsConfigOpenApiV2VO getDhcpSettings() {
        return this.dhcpSettings;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardOpenApiVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Dhcpv6GuardOpenApiVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public LanNetworkIpv6ConfigOpenApiVO getLanNetworkIpv6Config() {
        return this.lanNetworkIpv6Config;
    }

    @Generated
    public Boolean getArpDetectionEnable() {
        return this.arpDetectionEnable;
    }

    @Generated
    public Boolean getIsolation() {
        return this.isolation;
    }

    @Generated
    public Boolean getQosQueueEnable() {
        return this.qosQueueEnable;
    }

    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public OswIpSettingBriefOpenApiVO getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public OswDhcpServerOpenApiVO getDhcpServer() {
        return this.dhcpServer;
    }

    @Generated
    public OswDhcpRelayOpenApiVO getDhcpRelay() {
        return this.dhcpRelay;
    }

    @Generated
    public Boolean getSubnetOverrideEnable() {
        return this.subnetOverrideEnable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
    }

    @Generated
    public void setVlans(String vlans) {
        this.vlans = vlans;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setGatewaySubnet(String gatewaySubnet) {
        this.gatewaySubnet = gatewaySubnet;
    }

    @Generated
    public void setDhcpSettings(DhcpSettingsConfigOpenApiV2VO dhcpSettings) {
        this.dhcpSettings = dhcpSettings;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
    }

    @Generated
    public void setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
    }

    @Generated
    public void setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
    }

    @Generated
    public void setDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
    }

    @Generated
    public void setDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
    }

    @Generated
    public void setLanNetworkIpv6Config(LanNetworkIpv6ConfigOpenApiVO lanNetworkIpv6Config) {
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
    }

    @Generated
    public void setArpDetectionEnable(Boolean arpDetectionEnable) {
        this.arpDetectionEnable = arpDetectionEnable;
    }

    @Generated
    public void setIsolation(Boolean isolation) {
        this.isolation = isolation;
    }

    @Generated
    public void setQosQueueEnable(Boolean qosQueueEnable) {
        this.qosQueueEnable = qosQueueEnable;
    }

    @Generated
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setIp(OswIpSettingBriefOpenApiVO ip) {
        this.ip = ip;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setVrfId(String vrfId) {
        this.vrfId = vrfId;
    }

    @Generated
    public void setDhcpServer(OswDhcpServerOpenApiVO dhcpServer) {
        this.dhcpServer = dhcpServer;
    }

    @Generated
    public void setDhcpRelay(OswDhcpRelayOpenApiVO dhcpRelay) {
        this.dhcpRelay = dhcpRelay;
    }

    @Generated
    public void setSubnetOverrideEnable(Boolean subnetOverrideEnable) {
        this.subnetOverrideEnable = subnetOverrideEnable;
    }

    @Generated
    public String toString() {
        return "LanNetworkOpenApiV3VO(name=" + this.getName() + ", vlanType=" + this.getVlanType() + ", vlans=" + this.getVlans() + ", vlan=" + this.getVlan() + ", gatewaySubnet=" + this.getGatewaySubnet() + ", dhcpSettings=" + this.getDhcpSettings() + ", domain=" + this.getDomain() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", lanNetworkIpv6Config=" + this.getLanNetworkIpv6Config() + ", arpDetectionEnable=" + this.getArpDetectionEnable() + ", isolation=" + this.getIsolation() + ", qosQueueEnable=" + this.getQosQueueEnable() + ", queueId=" + this.getQueueId() + ", deviceType=" + this.getDeviceType() + ", deviceMac=" + this.getDeviceMac() + ", stackId=" + this.getStackId() + ", ip=" + this.getIp() + ", mode=" + this.getMode() + ", vrfId=" + this.getVrfId() + ", dhcpServer=" + this.getDhcpServer() + ", dhcpRelay=" + this.getDhcpRelay() + ", subnetOverrideEnable=" + this.getSubnetOverrideEnable() + ")";
    }

    @Generated
    public LanNetworkOpenApiV3VO(String name, Integer vlanType, String vlans, Integer vlan, String gatewaySubnet, DhcpSettingsConfigOpenApiV2VO dhcpSettings, String domain, Boolean igmpSnoopEnable, Boolean mldSnoopEnable, Boolean dhcpL2RelayEnable, DhcpGuardOpenApiVO dhcpGuard, Dhcpv6GuardOpenApiVO dhcpv6Guard, LanNetworkIpv6ConfigOpenApiVO lanNetworkIpv6Config, Boolean arpDetectionEnable, Boolean isolation, Boolean qosQueueEnable, Integer queueId, Integer deviceType, String deviceMac, String stackId, OswIpSettingBriefOpenApiVO ip, Integer mode, String vrfId, OswDhcpServerOpenApiVO dhcpServer, OswDhcpRelayOpenApiVO dhcpRelay, Boolean subnetOverrideEnable) {
        this.name = name;
        this.vlanType = vlanType;
        this.vlans = vlans;
        this.vlan = vlan;
        this.gatewaySubnet = gatewaySubnet;
        this.dhcpSettings = dhcpSettings;
        this.domain = domain;
        this.igmpSnoopEnable = igmpSnoopEnable;
        this.mldSnoopEnable = mldSnoopEnable;
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        this.dhcpGuard = dhcpGuard;
        this.dhcpv6Guard = dhcpv6Guard;
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
        this.arpDetectionEnable = arpDetectionEnable;
        this.isolation = isolation;
        this.qosQueueEnable = qosQueueEnable;
        this.queueId = queueId;
        this.deviceType = deviceType;
        this.deviceMac = deviceMac;
        this.stackId = stackId;
        this.ip = ip;
        this.mode = mode;
        this.vrfId = vrfId;
        this.dhcpServer = dhcpServer;
        this.dhcpRelay = dhcpRelay;
        this.subnetOverrideEnable = subnetOverrideEnable;
    }

    @Generated
    public LanNetworkOpenApiV3VO() {
    }
}

