/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IpsSignatureInfo", description="IPS signature Info entity")
public class IpsSignatureOpenApiVO {
    @NotNull(message="Parameter [id] is null.")
    @Schema(name="id", description="The unique identity of the signature suppresses.")
    private @NotNull(message="Parameter [id] is null.") String id;
    @NotNull(message="Parameter [classification] is null.")
    @Schema(name="classification", description="Attack service concrete classification.", example="misc-attack")
    private @NotNull(message="Parameter [classification] is null.") String classification;
    @NotNull(message="Parameter [category] is null.")
    @Schema(name="category", description="Attack service wide category.", example="2")
    private @NotNull(message="Parameter [category] is null.") Integer category;
    @NotNull(message="Parameter [signature] is null.")
    @Schema(name="signature", description="Attack service signature.")
    private @NotNull(message="Parameter [signature] is null.") String signature;
    @NotNull(message="Parameter [sid] is null.")
    @Schema(name="sid", description="IPS signature rule SID which is from device.", example="240201")
    private @NotNull(message="Parameter [sid] is null.") Long sid;
    @NotNull(message="Parameter [service] is null.")
    @Schema(name="service", description="Attack service service, the same as parameter[signature]")
    private @NotNull(message="Parameter [service] is null.") String service;
    @Schema(name="type", description="Type should be a value as follow: 0: all traffic; 1: packet tracking", example="1", requiredMode=Schema.RequiredMode.REQUIRED)
    @Range(min=0L, max=1L, message="IPS signature type should be 0 or 1.")
    private @Range(min=0L, max=1L, message="IPS signature type should be 0 or 1.") Integer type;
    @Schema(name="direction", description="Direction should be a value as follow: 0: both direction; 1: source direction; 2: destination direction", example="1")
    @Range(min=0L, max=2L, message="IPS signature direction should between 0 and 2.")
    private @Range(min=0L, max=2L, message="IPS signature direction should between 0 and 2.") Integer direction;
    @Schema(name="trafficType", description="TrafficType should be a value as follow: 0: ip address; 1: subnet", example="0")
    @Range(min=0L, max=1L, message="IPS signature traffic type should be 0 or 1.")
    private @Range(min=0L, max=1L, message="IPS signature traffic type should be 0 or 1.") Integer trafficType;
    @Schema(name="trafficSource", description="IPS signature traffic Source. If parameter [trafficType] is 0, parameter [trafficSource] should be IPV4 address. If parameter [trafficType] is 1, parameter [trafficSource] should be subnet address.", example="192.168.0.1")
    private String trafficSource;

    @Generated
    protected IpsSignatureOpenApiVO(IpsSignatureOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.classification = b2.classification;
        this.category = b2.category;
        this.signature = b2.signature;
        this.sid = b2.sid;
        this.service = b2.service;
        this.type = b2.type;
        this.direction = b2.direction;
        this.trafficType = b2.trafficType;
        this.trafficSource = b2.trafficSource;
    }

    @Generated
    public static IpsSignatureOpenApiVOBuilder<?, ?> builder() {
        return new IpsSignatureOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getClassification() {
        return this.classification;
    }

    @Generated
    public Integer getCategory() {
        return this.category;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public Long getSid() {
        return this.sid;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @Generated
    public Integer getTrafficType() {
        return this.trafficType;
    }

    @Generated
    public String getTrafficSource() {
        return this.trafficSource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setClassification(String classification) {
        this.classification = classification;
    }

    @Generated
    public void setCategory(Integer category) {
        this.category = category;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Generated
    public void setSid(Long sid) {
        this.sid = sid;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    @Generated
    public void setTrafficType(Integer trafficType) {
        this.trafficType = trafficType;
    }

    @Generated
    public void setTrafficSource(String trafficSource) {
        this.trafficSource = trafficSource;
    }

    @Generated
    public String toString() {
        return "IpsSignatureOpenApiVO(id=" + this.getId() + ", classification=" + this.getClassification() + ", category=" + this.getCategory() + ", signature=" + this.getSignature() + ", sid=" + this.getSid() + ", service=" + this.getService() + ", type=" + this.getType() + ", direction=" + this.getDirection() + ", trafficType=" + this.getTrafficType() + ", trafficSource=" + this.getTrafficSource() + ")";
    }

    @Generated
    public IpsSignatureOpenApiVO(String id, String classification, Integer category, String signature, Long sid, String service, Integer type, Integer direction, Integer trafficType, String trafficSource) {
        this.id = id;
        this.classification = classification;
        this.category = category;
        this.signature = signature;
        this.sid = sid;
        this.service = service;
        this.type = type;
        this.direction = direction;
        this.trafficType = trafficType;
        this.trafficSource = trafficSource;
    }

    @Generated
    public IpsSignatureOpenApiVO() {
    }

    @Generated
    public static abstract class IpsSignatureOpenApiVOBuilder<C extends IpsSignatureOpenApiVO, B extends IpsSignatureOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String classification;
        @Generated
        private Integer category;
        @Generated
        private String signature;
        @Generated
        private Long sid;
        @Generated
        private String service;
        @Generated
        private Integer type;
        @Generated
        private Integer direction;
        @Generated
        private Integer trafficType;
        @Generated
        private String trafficSource;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B classification(String classification) {
            this.classification = classification;
            return this.self();
        }

        @Generated
        public B category(Integer category) {
            this.category = category;
            return this.self();
        }

        @Generated
        public B signature(String signature) {
            this.signature = signature;
            return this.self();
        }

        @Generated
        public B sid(Long sid) {
            this.sid = sid;
            return this.self();
        }

        @Generated
        public B service(String service) {
            this.service = service;
            return this.self();
        }

        @Generated
        public B type(Integer type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B direction(Integer direction) {
            this.direction = direction;
            return this.self();
        }

        @Generated
        public B trafficType(Integer trafficType) {
            this.trafficType = trafficType;
            return this.self();
        }

        @Generated
        public B trafficSource(String trafficSource) {
            this.trafficSource = trafficSource;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IpsSignatureOpenApiVO.IpsSignatureOpenApiVOBuilder(id=" + this.id + ", classification=" + this.classification + ", category=" + this.category + ", signature=" + this.signature + ", sid=" + this.sid + ", service=" + this.service + ", type=" + this.type + ", direction=" + this.direction + ", trafficType=" + this.trafficType + ", trafficSource=" + this.trafficSource + ")";
        }
    }

    @Generated
    private static final class IpsSignatureOpenApiVOBuilderImpl
    extends IpsSignatureOpenApiVOBuilder<IpsSignatureOpenApiVO, IpsSignatureOpenApiVOBuilderImpl> {
        @Generated
        private IpsSignatureOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected IpsSignatureOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IpsSignatureOpenApiVO build() {
            return new IpsSignatureOpenApiVO(this);
        }
    }
}

