/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IpsSignatureConfig", description="IPS signature configuration")
public class IpsSignatureConfigOpenApiVO {
    @Schema(name="type", description="Type should be a value as follow: 0: all traffic; 1: packet tracking", example="1", requiredMode=Schema.RequiredMode.REQUIRED)
    @Range(min=0L, max=1L, message="Type should be 0 or 1.")
    @NotNull(message="Parameter [Type] is null.")
    private @Range(min=0L, max=1L, message="Type should be 0 or 1.") @NotNull(message="Parameter [Type] is null.") Integer type;
    @Schema(name="direction", description="Direction should be a value as follow: 0: both direction; 1: source direction; 2: destination direction", example="1")
    @Range(min=0L, max=2L, message="Direction should be within the range of 0-2")
    private @Range(min=0L, max=2L, message="Direction should be within the range of 0-2") Integer direction;
    @Schema(name="trafficType", description="TrafficType should be a value as follow: 0: ip address; 1: subnet", example="0")
    @Range(min=0L, max=1L, message="TrafficType should be 0 or 1.")
    private @Range(min=0L, max=1L, message="TrafficType should be 0 or 1.") Integer trafficType;
    @Schema(name="ip", description="IPS signature traffic Source. If parameter [trafficType] is 0, parameter [ip] is needed", example="192.168.0.1")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="parameter should be valid ipv4 address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="parameter should be valid ipv4 address.") String ip;
    @Schema(name="subnet", description="IPS signature traffic Source. If parameter [trafficType] is 1, parameter [subnet] is needed", example="192.168.0.0/24")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/([1-9]|((1|2)\\d)|(30|31|32))\\b", message="parameter should be valid subnet.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/([1-9]|((1|2)\\d)|(30|31|32))\\b", message="parameter should be valid subnet.") String subnet;

    @Generated
    protected IpsSignatureConfigOpenApiVO(IpsSignatureConfigOpenApiVOBuilder<?, ?> b2) {
        this.type = b2.type;
        this.direction = b2.direction;
        this.trafficType = b2.trafficType;
        this.ip = b2.ip;
        this.subnet = b2.subnet;
    }

    @Generated
    public static IpsSignatureConfigOpenApiVOBuilder<?, ?> builder() {
        return new IpsSignatureConfigOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @Generated
    public Integer getTrafficType() {
        return this.trafficType;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getSubnet() {
        return this.subnet;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    @Generated
    public void setTrafficType(Integer trafficType) {
        this.trafficType = trafficType;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    @Generated
    public String toString() {
        return "IpsSignatureConfigOpenApiVO(type=" + this.getType() + ", direction=" + this.getDirection() + ", trafficType=" + this.getTrafficType() + ", ip=" + this.getIp() + ", subnet=" + this.getSubnet() + ")";
    }

    @Generated
    public IpsSignatureConfigOpenApiVO(Integer type, Integer direction, Integer trafficType, String ip, String subnet) {
        this.type = type;
        this.direction = direction;
        this.trafficType = trafficType;
        this.ip = ip;
        this.subnet = subnet;
    }

    @Generated
    public IpsSignatureConfigOpenApiVO() {
    }

    @Generated
    public static abstract class IpsSignatureConfigOpenApiVOBuilder<C extends IpsSignatureConfigOpenApiVO, B extends IpsSignatureConfigOpenApiVOBuilder<C, B>> {
        @Generated
        private Integer type;
        @Generated
        private Integer direction;
        @Generated
        private Integer trafficType;
        @Generated
        private String ip;
        @Generated
        private String subnet;

        @Generated
        public B type(Integer type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B direction(Integer direction) {
            this.direction = direction;
            return this.self();
        }

        @Generated
        public B trafficType(Integer trafficType) {
            this.trafficType = trafficType;
            return this.self();
        }

        @Generated
        public B ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        @Generated
        public B subnet(String subnet) {
            this.subnet = subnet;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IpsSignatureConfigOpenApiVO.IpsSignatureConfigOpenApiVOBuilder(type=" + this.type + ", direction=" + this.direction + ", trafficType=" + this.trafficType + ", ip=" + this.ip + ", subnet=" + this.subnet + ")";
        }
    }

    @Generated
    private static final class IpsSignatureConfigOpenApiVOBuilderImpl
    extends IpsSignatureConfigOpenApiVOBuilder<IpsSignatureConfigOpenApiVO, IpsSignatureConfigOpenApiVOBuilderImpl> {
        @Generated
        private IpsSignatureConfigOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected IpsSignatureConfigOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IpsSignatureConfigOpenApiVO build() {
            return new IpsSignatureConfigOpenApiVO(this);
        }
    }
}

