/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IpsInfo", description="IPS config entity")
public class IpsInfoOpenApiVO {
    @NotNull(message="Parameter [enable] is null")
    @Schema(name="enable", description="Whether to enable IDS/IPS config. If parameter[enable] is true, parameter[ipsMode] and parameter[dplevel] are needed")
    private @NotNull(message="Parameter [enable] is null") Boolean enable;
    @Schema(name="ipsMode", description="IpsMode should be a value as follows: 0: detect only; 1: detect and block", example="1")
    @Range(min=0L, max=1L, message="IDS/IPS mode should be 0 or 1")
    private @Range(min=0L, max=1L, message="IDS/IPS mode should be 0 or 1") Integer ipsMode;
    @Schema(name="geoEnable", description="Whether to enable identifying the source country and destination country of attack ip addresses.", example="false")
    private Boolean geoEnable;
    @Schema(name="dpLevel", description="DpLevel should be a value as follows: 0: Low; 1: Medium; 2: High; 3: Custom", example="0")
    @Range(min=0L, max=3L, message="Detect and prevent level should be within the range of 0-3")
    private @Range(min=0L, max=3L, message="Detect and prevent level should be within the range of 0-3") Integer dpLevel;
    @Schema(name="customCategories", description="Custom IDS/IPS categories list, if parameter[Dplevel] is 3, customCategories is needed.CustomCategories should be a list as follow: 1: Botcc, 2: Worm, 3: Malware, 4: Mobile_Malware, 6: P2P, 7: Tor, 8: Exploit, 9: Shellcode, 14: Activex, 15: DNS, 18: User Agents, 24: DShield", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private List<Integer> customCategories;
    @Schema(name="timeRangeId", description="This field represents Time Range ID. Time Range can be created using 'Create time range profile' interface, and Time Range ID can be obtained from 'Get time range profile list' interface. If parameter[timeRangeId] is null, IDS/IPS will be effective in all time ranges.")
    private String timeRangeId;

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getIpsMode() {
        return this.ipsMode;
    }

    @Generated
    public Boolean getGeoEnable() {
        return this.geoEnable;
    }

    @Generated
    public Integer getDpLevel() {
        return this.dpLevel;
    }

    @Generated
    public List<Integer> getCustomCategories() {
        return this.customCategories;
    }

    @Generated
    public String getTimeRangeId() {
        return this.timeRangeId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setIpsMode(Integer ipsMode) {
        this.ipsMode = ipsMode;
    }

    @Generated
    public void setGeoEnable(Boolean geoEnable) {
        this.geoEnable = geoEnable;
    }

    @Generated
    public void setDpLevel(Integer dpLevel) {
        this.dpLevel = dpLevel;
    }

    @Generated
    public void setCustomCategories(List<Integer> customCategories) {
        this.customCategories = customCategories;
    }

    @Generated
    public void setTimeRangeId(String timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public String toString() {
        return "IpsInfoOpenApiVO(enable=" + this.getEnable() + ", ipsMode=" + this.getIpsMode() + ", geoEnable=" + this.getGeoEnable() + ", dpLevel=" + this.getDpLevel() + ", customCategories=" + this.getCustomCategories() + ", timeRangeId=" + this.getTimeRangeId() + ")";
    }

    @Generated
    public IpsInfoOpenApiVO(Boolean enable, Integer ipsMode, Boolean geoEnable, Integer dpLevel, List<Integer> customCategories, String timeRangeId) {
        this.enable = enable;
        this.ipsMode = ipsMode;
        this.geoEnable = geoEnable;
        this.dpLevel = dpLevel;
        this.customCategories = customCategories;
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public IpsInfoOpenApiVO() {
    }
}

