/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.hibernate.validator.constraints.Range;

@Schema(name="Modify IPS allow list entry")
public class EditAllowListOpenApiVO {
    @NotBlank
    @Schema(name="id", description="Allow list entry ID.")
    private String id;
    @Schema(name="direction", description="The location of the target that can trigger the threat, direction should be a value as follows:0: both 1: source, 2: destination.")
    @Range(max=2L, min=0L, message="Value of direction is from 0 to 2")
    @NonNull
    private @Range(max=2L, min=0L, message="Value of direction is from 0 to 2") @NonNull Integer direction;
    @Schema(name="trafficType", description="Exempt the category of objects (targets) that can trigger the threat, trafficType should be a value as follows: 0: IP Address, 1: Network, 2: Subnet.")
    @Range(max=2L, min=0L, message="Value of allow is from 0 to 2")
    @NonNull
    private @Range(max=2L, min=0L, message="Value of allow is from 0 to 2") @NonNull Integer trafficType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address")
    @Schema(name="ipAddress", description="The value of the trafficType is 0, indicating IP address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address") String ipAddress;
    @Schema(name="network", description="The value of the trafficType is 1, indicating LAN network ID.")
    private String network;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid subnet")
    @Schema(name="subnet", description="The value of the trafficType is 2, indicating subnet.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid subnet") String subnet;

    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @NonNull
    @Generated
    public Integer getTrafficType() {
        return this.trafficType;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getNetwork() {
        return this.network;
    }

    @Generated
    public String getSubnet() {
        return this.subnet;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDirection(@NonNull Integer direction) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        this.direction = direction;
    }

    @Generated
    public void setTrafficType(@NonNull Integer trafficType) {
        if (trafficType == null) {
            throw new NullPointerException("trafficType is marked non-null but is null");
        }
        this.trafficType = trafficType;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setNetwork(String network) {
        this.network = network;
    }

    @Generated
    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditAllowListOpenApiVO)) {
            return false;
        }
        EditAllowListOpenApiVO other = (EditAllowListOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$direction = this.getDirection();
        Integer other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)this$direction).equals(other$direction)) {
            return false;
        }
        Integer this$trafficType = this.getTrafficType();
        Integer other$trafficType = other.getTrafficType();
        if (this$trafficType == null ? other$trafficType != null : !((Object)this$trafficType).equals(other$trafficType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        String this$subnet = this.getSubnet();
        String other$subnet = other.getSubnet();
        return !(this$subnet == null ? other$subnet != null : !this$subnet.equals(other$subnet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditAllowListOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)$direction).hashCode());
        Integer $trafficType = this.getTrafficType();
        result = result * 59 + ($trafficType == null ? 43 : ((Object)$trafficType).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        String $subnet = this.getSubnet();
        result = result * 59 + ($subnet == null ? 43 : $subnet.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EditAllowListOpenApiVO(id=" + this.getId() + ", direction=" + this.getDirection() + ", trafficType=" + this.getTrafficType() + ", ipAddress=" + this.getIpAddress() + ", network=" + this.getNetwork() + ", subnet=" + this.getSubnet() + ")";
    }

    @Generated
    public EditAllowListOpenApiVO() {
    }

    @Generated
    public EditAllowListOpenApiVO(String id, @NonNull Integer direction, @NonNull Integer trafficType, String ipAddress, String network, String subnet) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        if (trafficType == null) {
            throw new NullPointerException("trafficType is marked non-null but is null");
        }
        this.id = id;
        this.direction = direction;
        this.trafficType = trafficType;
        this.ipAddress = ipAddress;
        this.network = network;
        this.subnet = subnet;
    }
}

