/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.gatewayqos.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class QosBwcOpenApiVO {
    @Schema(name="wan", description="The ID of WAN port to which this Bandwidth Control applies. Each WAN port can only be configured with one rule. WAN ID can be obtained from 'Get WAN ports info for Gateway QoS' interface.")
    @NotNull(message="Parameter [wan] can not be null.")
    private @NotNull(message="Parameter [wan] can not be null.") String wan;
    @Schema(name="status", description="The status of Bandwidth Control rule, valid values are true or false.")
    @NotNull(message="Parameter [status] can not be null.")
    private @NotNull(message="Parameter [status] can not be null.") Boolean status;
    @Schema(name="udpBandwidthCtrl", description="The UDP Bandwidth Control of Bandwidth Control rule, valid values are true or false.")
    @NotNull(message="Parameter [udpBandwidthCtrl] can not be null.")
    private @NotNull(message="Parameter [udpBandwidthCtrl] can not be null.") Boolean udpBandwidthCtrl;
    @Schema(name="udpRatio", description="The Limited Bandwidth Ratio of Bandwidth Control rule. It should be within the range of 0-100 when parameter [udpBandwidthCtrl] is true.")
    @Range(min=0L, max=100L, message="Parameter [udpRatio] must be between 0 and 100.")
    private @Range(min=0L, max=100L, message="Parameter [udpRatio] must be between 0 and 100.") Integer udpRatio;
    @Schema(name="outPrioritization", description="The Outbound TCP ACK Prioritize of Bandwidth Control rule, valid values are true or false.")
    @NotNull(message="Parameter [outPrioritization] can not be null.")
    private @NotNull(message="Parameter [outPrioritization] can not be null.") Boolean outPrioritization;
    @Schema(name="direction", description="The direction value selected in the Direction configuration should be a value as follows: 0: Inbound; 1: Outbound; 2: Both.")
    @NotNull(message="Parameter [direction] can not be null.")
    @Range(min=0L, max=2L, message="Parameter [direction] must be 0, 1 or 2.")
    private @NotNull(message="Parameter [direction] can not be null.") @Range(min=0L, max=2L, message="Parameter [direction] must be 0, 1 or 2.") Integer direction;
    @Schema(name="inBandwidth", description="The Inbound Bandwidth of Bandwidth Control rule should be within the range of 100-1000000.")
    @NotNull(message="Parameter [inBandwidth] can not be null.")
    @Range(min=100L, max=1000000L, message="Parameter [inBandwidth] must be between 100 and 1000000.")
    private @NotNull(message="Parameter [inBandwidth] can not be null.") @Range(min=100L, max=1000000L, message="Parameter [inBandwidth] must be between 100 and 1000000.") Integer inBandwidth;
    @Schema(name="outBandwidth", description="The Outbound Bandwidth of Bandwidth Control rule should be within the range of 100-1000000.")
    @NotNull(message="Parameter [outBandwidth] can not be null.")
    @Range(min=100L, max=1000000L, message="Parameter [outBandwidth] must be between 100 and 1000000.")
    private @NotNull(message="Parameter [outBandwidth] can not be null.") @Range(min=100L, max=1000000L, message="Parameter [outBandwidth] must be between 100 and 1000000.") Integer outBandwidth;
    @Schema(name="classRatio", description="The ratio of class type, value's format is [class1 ratio, class2 ratio, class3 ratio, others ratio], and the total sum should be 100.")
    @NotNull(message="Parameter [classRatio] can not be null.")
    private @NotNull(message="Parameter [classRatio] can not be null.") List<Integer> classRatio;

    @Generated
    public String getWan() {
        return this.wan;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getUdpBandwidthCtrl() {
        return this.udpBandwidthCtrl;
    }

    @Generated
    public Integer getUdpRatio() {
        return this.udpRatio;
    }

    @Generated
    public Boolean getOutPrioritization() {
        return this.outPrioritization;
    }

    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @Generated
    public Integer getInBandwidth() {
        return this.inBandwidth;
    }

    @Generated
    public Integer getOutBandwidth() {
        return this.outBandwidth;
    }

    @Generated
    public List<Integer> getClassRatio() {
        return this.classRatio;
    }

    @Generated
    public QosBwcOpenApiVO setWan(String wan) {
        this.wan = wan;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setUdpBandwidthCtrl(Boolean udpBandwidthCtrl) {
        this.udpBandwidthCtrl = udpBandwidthCtrl;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setUdpRatio(Integer udpRatio) {
        this.udpRatio = udpRatio;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setOutPrioritization(Boolean outPrioritization) {
        this.outPrioritization = outPrioritization;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setInBandwidth(Integer inBandwidth) {
        this.inBandwidth = inBandwidth;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setOutBandwidth(Integer outBandwidth) {
        this.outBandwidth = outBandwidth;
        return this;
    }

    @Generated
    public QosBwcOpenApiVO setClassRatio(List<Integer> classRatio) {
        this.classRatio = classRatio;
        return this;
    }
}

