/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.MacAuthVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.embed.SsidSimpleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class UpdateMacAuthOpenApiVO {
    @NotNull(message="MacAuth enable should not be null")
    @Schema(name="enable", description="MAC-Based Authentication enable status")
    private @NotNull(message="MacAuth enable should not be null") Boolean enable;
    @NotNull
    @Schema(name="ssids", description="SSID ID list with MAC-Based authentication configured. SSID can be created using 'Create new SSID' ('Create new SSID template') interface, and SSID ID can be obtained from 'Get SSID list' ('Get SSID template list') interface")
    private List<String> ssids;
    @Schema(name="radiusProfileId", description="This field represents radius profile ID. Radius profile can be created using 'Create a new Radius profile' ('Create a new Radius profile template') interface, and radius profile ID can be obtained from 'Get Radius profile list' ('Get Radius profile template list') interface")
    private String radiusProfileId;
    @Schema(name="mabEnable", description="MAB enable status")
    private Boolean mabEnable;
    @Schema(name="macFormat", description="Format of the MAC address. MacFormat should be a value as follows: 0: aabbccddeeff, 1: aa-bb-cc-dd-ee-ff, 2: aa:bb:cc:dd:ee:ff, 3: AABBCCDDEEFF, 4: AA-BB-CC-DD-EE-FF, 5: AA:BB:CC:DD:EE:FF")
    private Integer macFormat;
    @Schema(name="emptyPwdEnable", description="Whether to enable empty password")
    private Boolean emptyPwdEnable;
    @Nullable
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Invalid NAS ID.")
    @Schema(name="nasId", description="NAS ID issued to AP. NasId should contain 1 to 64 characters")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Invalid NAS ID.") String nasId;

    public OperationResponse check() {
        if (!Boolean.TRUE.equals(this.enable)) {
            return OperationResponse.SUCCESS;
        }
        if (CollectionUtils.isEmpty(this.ssids)) {
            return new OperationResponse(b.d, "Parameter [ssids] should not be empty.", null);
        }
        if (T.a((String)this.radiusProfileId)) {
            return new OperationResponse(b.d, "Parameter [radiusProfileId] should not be null.", null);
        }
        if (this.mabEnable == null) {
            return new OperationResponse(b.d, "Parameter [mabEnable] should not be null.", null);
        }
        if (this.macFormat == null) {
            return new OperationResponse(b.d, "Parameter [macFormat] should not be null.", null);
        }
        if (this.emptyPwdEnable == null) {
            return new OperationResponse(b.d, "Parameter [emptyPwdEnable] should not be null.", null);
        }
        return OperationResponse.SUCCESS;
    }

    public MacAuthVO toMacAuthVO() {
        MacAuthVO vo = new MacAuthVO();
        vo.setEnable(this.enable);
        vo.setSsids(CollectionUtils.isEmpty(this.ssids) ? Collections.emptyList() : this.ssids.stream().map(ssid -> {
            SsidSimpleVO ssidSimpleVO = new SsidSimpleVO();
            ssidSimpleVO.setSsidId(ssid);
            return ssidSimpleVO;
        }).collect(Collectors.toList()));
        vo.setRadiusProfileId(this.radiusProfileId);
        vo.setMabEnable(this.mabEnable);
        vo.setMacFormat(this.macFormat);
        vo.setEmptyPwdEable(this.emptyPwdEnable);
        vo.setNasId(this.nasId);
        return vo;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getSsids() {
        return this.ssids;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Boolean getMabEnable() {
        return this.mabEnable;
    }

    @Generated
    public Integer getMacFormat() {
        return this.macFormat;
    }

    @Generated
    public Boolean getEmptyPwdEnable() {
        return this.emptyPwdEnable;
    }

    @Nullable
    @Generated
    public String getNasId() {
        return this.nasId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setSsids(List<String> ssids) {
        this.ssids = ssids;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setMabEnable(Boolean mabEnable) {
        this.mabEnable = mabEnable;
    }

    @Generated
    public void setMacFormat(Integer macFormat) {
        this.macFormat = macFormat;
    }

    @Generated
    public void setEmptyPwdEnable(Boolean emptyPwdEnable) {
        this.emptyPwdEnable = emptyPwdEnable;
    }

    @Generated
    public void setNasId(@Nullable String nasId) {
        this.nasId = nasId;
    }

    @Generated
    public String toString() {
        return "UpdateMacAuthOpenApiVO(enable=" + this.getEnable() + ", ssids=" + this.getSsids() + ", radiusProfileId=" + this.getRadiusProfileId() + ", mabEnable=" + this.getMabEnable() + ", macFormat=" + this.getMacFormat() + ", emptyPwdEnable=" + this.getEmptyPwdEnable() + ", nasId=" + this.getNasId() + ")";
    }

    @Generated
    public UpdateMacAuthOpenApiVO(Boolean enable, List<String> ssids, String radiusProfileId, Boolean mabEnable, Integer macFormat, Boolean emptyPwdEnable, @Nullable String nasId) {
        this.enable = enable;
        this.ssids = ssids;
        this.radiusProfileId = radiusProfileId;
        this.mabEnable = mabEnable;
        this.macFormat = macFormat;
        this.emptyPwdEnable = emptyPwdEnable;
        this.nasId = nasId;
    }

    @Generated
    public UpdateMacAuthOpenApiVO() {
    }
}

