/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.SsidSimpleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.MacAuthVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class MacAuthOpenApiVO {
    @Schema(name="enable", description="MAC-Based Authentication enable status")
    private Boolean enable;
    @Schema(name="ssids", description="SSID list with MAC-Based authentication configured")
    private List<SsidSimpleOpenApiVO> ssids;
    @Schema(name="radiusProfileId", description="This field represents radius profile ID. Radius profile can be created using 'Create a new Radius profile' ('Create a new Radius profile template') interface, and radius profile ID can be obtained from 'Get Radius profile list' ('Get Radius profile template list') interface")
    private String radiusProfileId;
    @Schema(name="mabEnable", description="MAB enable status")
    private Boolean mabEnable;
    @Schema(name="macFormat", description="Format of the MAC address. MacFormat should be a value as follows: 0: aabbccddeeff, 1: aa-bb-cc-dd-ee-ff, 2: aa:bb:cc:dd:ee:ff, 3: AABBCCDDEEFF, 4: AA-BB-CC-DD-EE-FF, 5: AA:BB:CC:DD:EE:FF")
    private Integer macFormat;
    @Schema(name="emptyPwdEnable", description="Whether to enable empty password")
    private Boolean emptyPwdEnable;
    @Schema(name="nasId", description="NAS ID issued to AP. NasId should contain 1 to 64 characters")
    private String nasId;

    public static MacAuthOpenApiVO toMacAuthOpenApiVO(MacAuthVO vo) {
        MacAuthOpenApiVO macAuthOpenApiVO = new MacAuthOpenApiVO();
        macAuthOpenApiVO.setEnable(vo.getEnable());
        macAuthOpenApiVO.setSsids(CollectionUtils.isEmpty((Collection)vo.getSsids()) ? Collections.emptyList() : vo.getSsids().stream().map(SsidSimpleOpenApiVO::toSsidSimpleOpenApiVO).collect(Collectors.toList()));
        macAuthOpenApiVO.setRadiusProfileId(vo.getRadiusProfileId());
        macAuthOpenApiVO.setMabEnable(vo.getMabEnable());
        macAuthOpenApiVO.setMacFormat(vo.getMacFormat());
        macAuthOpenApiVO.setEmptyPwdEnable(vo.getEmptyPwdEable());
        macAuthOpenApiVO.setNasId(vo.getNasId());
        return macAuthOpenApiVO;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<SsidSimpleOpenApiVO> getSsids() {
        return this.ssids;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Boolean getMabEnable() {
        return this.mabEnable;
    }

    @Generated
    public Integer getMacFormat() {
        return this.macFormat;
    }

    @Generated
    public Boolean getEmptyPwdEnable() {
        return this.emptyPwdEnable;
    }

    @Generated
    public String getNasId() {
        return this.nasId;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setSsids(List<SsidSimpleOpenApiVO> ssids) {
        this.ssids = ssids;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setMabEnable(Boolean mabEnable) {
        this.mabEnable = mabEnable;
    }

    @Generated
    public void setMacFormat(Integer macFormat) {
        this.macFormat = macFormat;
    }

    @Generated
    public void setEmptyPwdEnable(Boolean emptyPwdEnable) {
        this.emptyPwdEnable = emptyPwdEnable;
    }

    @Generated
    public void setNasId(String nasId) {
        this.nasId = nasId;
    }

    @Generated
    public String toString() {
        return "MacAuthOpenApiVO(enable=" + this.getEnable() + ", ssids=" + this.getSsids() + ", radiusProfileId=" + this.getRadiusProfileId() + ", mabEnable=" + this.getMabEnable() + ", macFormat=" + this.getMacFormat() + ", emptyPwdEnable=" + this.getEmptyPwdEnable() + ", nasId=" + this.getNasId() + ")";
    }

    @Generated
    public MacAuthOpenApiVO(Boolean enable, List<SsidSimpleOpenApiVO> ssids, String radiusProfileId, Boolean mabEnable, Integer macFormat, Boolean emptyPwdEnable, String nasId) {
        this.enable = enable;
        this.ssids = ssids;
        this.radiusProfileId = radiusProfileId;
        this.mabEnable = mabEnable;
        this.macFormat = macFormat;
        this.emptyPwdEnable = emptyPwdEnable;
        this.nasId = nasId;
    }

    @Generated
    public MacAuthOpenApiVO() {
    }
}

