/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xSwitchSettingOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class Dot1xSwitchOpenApiVO {
    @NotNull(message="Parameter [enable] should not be null.")
    @Schema(name="enable", description="Switch 802.1x function enable status")
    private @NotNull(message="Parameter [enable] should not be null.") Boolean enable;
    @Schema(name="radiusProfileId", description="This field represents radius profile ID. Radius profile can be created using 'Create a new Radius profile' ('Create a new Radius profile template') interface, and radius profile ID can be obtained from 'Get Radius profile list' ('Get Radius profile template list') interface")
    private String radiusProfileId;
    @NumberSet(value={0, 1})
    @Schema(name="authMode", description="Mode of authentication protocol. AuthMode should be a value as follows: 0: PAP, 1: EAP")
    private Integer authMode;
    @NumberSet(value={0, 1})
    @Schema(name="authType", description="Type of the authentication. AuthType should be a value as follows: 0: MAC based, 1: Port based")
    private Integer authType;
    @Schema(name="vlanAssign", description="VLAN Assignment enable status")
    private Boolean vlanAssign;
    @Schema(name="mab", description="MAB enable status")
    private Boolean mab;
    @NumberSet(value={0, 1, 2, 3, 4, 5})
    @Schema(name="macFormat", description="Format of the MAC address. MacFormat should be a value as follows: 0: aabbccddeeff, 1: aa-bb-cc-dd-ee-ff, 2: aa:bb:cc:dd:ee:ff, 3: AABBCCDDEEFF, 4: AA-BB-CC-DD-EE-FF, 5: AA:BB:CC:DD:EE:FF")
    private Integer macFormat;
    @Schema(name="switches", description="Enabled switch ports, optional when update switch 802.1x setting")
    @Valid
    private List<Dot1xSwitchSettingOpenApiVO> switches;

    public OperationResponse check() {
        if (!Boolean.TRUE.equals(this.enable)) {
            return OperationResponse.SUCCESS;
        }
        if (T.a((String)this.radiusProfileId)) {
            return new OperationResponse(b.d, "Parameter [radiusProfileId] should not be null.", null);
        }
        if (this.authMode == null) {
            return new OperationResponse(b.d, "Parameter [authMode] should not be null.", null);
        }
        if (this.authType == null) {
            return new OperationResponse(b.d, "Parameter [authType] should not be null.", null);
        }
        if (this.vlanAssign == null) {
            return new OperationResponse(b.d, "Parameter [vlanAssign] should not be null.", null);
        }
        if (this.mab == null) {
            return new OperationResponse(b.d, "Parameter [mab] should not be null.", null);
        }
        if (this.macFormat == null) {
            return new OperationResponse(b.d, "Parameter [macFormat] should not be null.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public Boolean getVlanAssign() {
        return this.vlanAssign;
    }

    @Generated
    public Boolean getMab() {
        return this.mab;
    }

    @Generated
    public Integer getMacFormat() {
        return this.macFormat;
    }

    @Generated
    public List<Dot1xSwitchSettingOpenApiVO> getSwitches() {
        return this.switches;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setVlanAssign(Boolean vlanAssign) {
        this.vlanAssign = vlanAssign;
    }

    @Generated
    public void setMab(Boolean mab) {
        this.mab = mab;
    }

    @Generated
    public void setMacFormat(Integer macFormat) {
        this.macFormat = macFormat;
    }

    @Generated
    public void setSwitches(List<Dot1xSwitchSettingOpenApiVO> switches) {
        this.switches = switches;
    }

    @Generated
    public String toString() {
        return "Dot1xSwitchOpenApiVO(enable=" + this.getEnable() + ", radiusProfileId=" + this.getRadiusProfileId() + ", authMode=" + this.getAuthMode() + ", authType=" + this.getAuthType() + ", vlanAssign=" + this.getVlanAssign() + ", mab=" + this.getMab() + ", macFormat=" + this.getMacFormat() + ", switches=" + this.getSwitches() + ")";
    }

    @Generated
    public Dot1xSwitchOpenApiVO(Boolean enable, String radiusProfileId, Integer authMode, Integer authType, Boolean vlanAssign, Boolean mab, Integer macFormat, List<Dot1xSwitchSettingOpenApiVO> switches) {
        this.enable = enable;
        this.radiusProfileId = radiusProfileId;
        this.authMode = authMode;
        this.authType = authType;
        this.vlanAssign = vlanAssign;
        this.mab = mab;
        this.macFormat = macFormat;
        this.switches = switches;
    }

    @Generated
    public Dot1xSwitchOpenApiVO() {
    }
}

