/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.embed.Dot1xEapSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Dot1xEapSettingOpenApiVO {
    @NotNull
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @Schema(name="mac", description="MAC address of the EAP")
    @a
    private @NotNull @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    @Schema(name="dot1xPorts", description="EAP 802.1x enabled ports")
    private List<String> dot1xPorts;
    @Schema(name="mabPorts", description="EAP MAB enabled ports", hidden=true)
    private List<String> mabPorts;

    public static Dot1xEapSettingOpenApiVO toDot1xEapSettingOpenApiVO(Dot1xEapSettingVO vo) {
        Dot1xEapSettingOpenApiVO openApiVO = new Dot1xEapSettingOpenApiVO();
        openApiVO.setMac(vo.getMac());
        openApiVO.setDot1xPorts(vo.getDot1xPorts());
        return openApiVO;
    }

    public static Dot1xEapSettingVO toDot1xEapSettingVO(Dot1xEapSettingOpenApiVO openApiVO) {
        Dot1xEapSettingVO vo = new Dot1xEapSettingVO();
        vo.setMac(openApiVO.getMac());
        vo.setDot1xPorts(openApiVO.getDot1xPorts() == null ? Collections.emptyList() : openApiVO.getDot1xPorts());
        vo.setMabPorts(openApiVO.getDot1xPorts() == null ? Collections.emptyList() : openApiVO.getDot1xPorts());
        return vo;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public List<String> getDot1xPorts() {
        return this.dot1xPorts;
    }

    @Generated
    public List<String> getMabPorts() {
        return this.mabPorts;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setDot1xPorts(List<String> dot1xPorts) {
        this.dot1xPorts = dot1xPorts;
    }

    @Generated
    public void setMabPorts(List<String> mabPorts) {
        this.mabPorts = mabPorts;
    }

    @Generated
    public String toString() {
        return "Dot1xEapSettingOpenApiVO(mac=" + this.getMac() + ", dot1xPorts=" + this.getDot1xPorts() + ", mabPorts=" + this.getMabPorts() + ")";
    }

    @Generated
    public Dot1xEapSettingOpenApiVO(String mac, List<String> dot1xPorts, List<String> mabPorts) {
        this.mac = mac;
        this.dot1xPorts = dot1xPorts;
        this.mabPorts = mabPorts;
    }

    @Generated
    public Dot1xEapSettingOpenApiVO() {
    }
}

