/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xEapSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.Dot1xSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class Dot1xEapOpenApiVO {
    @NotNull(message="Parameter [enable] should not be null.")
    @Schema(name="enable", description="EAP 802.1x function enable status")
    private @NotNull(message="Parameter [enable] should not be null.") Boolean enable;
    @Schema(name="radiusProfileId", description="This field represents radius profile ID. Radius profile can be created using 'Create a new Radius profile' ('Create a new Radius profile template') interface, and radius profile ID can be obtained from 'Get Radius profile list' ('Get Radius profile template list') interface")
    private String radiusProfileId;
    @NumberSet(value={0, 1, 2, 3, 4, 5})
    @Schema(name="macFormat", description="Format of the MAC address. MacFormat should be a value as follows: 0: aabbccddeeff, 1: aa-bb-cc-dd-ee-ff, 2: aa:bb:cc:dd:ee:ff, 3: AABBCCDDEEFF, 4: AA-BB-CC-DD-EE-FF, 5: AA:BB:CC:DD:EE:FF")
    private Integer macFormat;
    @Schema(name="eaps", description="Enabled eap ports")
    @Valid
    private List<Dot1xEapSettingOpenApiVO> eaps;

    public static Dot1xEapOpenApiVO toDot1xEapOpenApiVO(Dot1xSettingVO vo) {
        Dot1xEapOpenApiVO openApiVO = new Dot1xEapOpenApiVO();
        openApiVO.setEnable(vo.getEnable());
        openApiVO.setRadiusProfileId(vo.getRadiusProfileId());
        openApiVO.setMacFormat(vo.getMacFormat());
        return openApiVO;
    }

    public OperationResponse check() {
        if (!Boolean.TRUE.equals(this.enable)) {
            return OperationResponse.SUCCESS;
        }
        if (T.a((String)this.radiusProfileId)) {
            return new OperationResponse(b.d, "Parameter [radiusProfileId] should not be null.", null);
        }
        if (this.macFormat == null) {
            return new OperationResponse(b.d, "Parameter [macFormat] should not be null.", null);
        }
        return OperationResponse.SUCCESS;
    }

    public Dot1xSettingVO toDot1xSettingVO() {
        Dot1xSettingVO vo = new Dot1xSettingVO();
        vo.setEnable(this.enable);
        vo.setRadiusProfileId(this.radiusProfileId);
        vo.setMab(Boolean.TRUE);
        vo.setMacFormat(this.macFormat);
        vo.setEaps(CollectionUtils.isEmpty(this.eaps) ? Collections.emptyList() : this.eaps.stream().map(Dot1xEapSettingOpenApiVO::toDot1xEapSettingVO).collect(Collectors.toList()));
        return vo;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Integer getMacFormat() {
        return this.macFormat;
    }

    @Generated
    public List<Dot1xEapSettingOpenApiVO> getEaps() {
        return this.eaps;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setMacFormat(Integer macFormat) {
        this.macFormat = macFormat;
    }

    @Generated
    public void setEaps(List<Dot1xEapSettingOpenApiVO> eaps) {
        this.eaps = eaps;
    }

    @Generated
    public String toString() {
        return "Dot1xEapOpenApiVO(enable=" + this.getEnable() + ", radiusProfileId=" + this.getRadiusProfileId() + ", macFormat=" + this.getMacFormat() + ", eaps=" + this.getEaps() + ")";
    }

    @Generated
    public Dot1xEapOpenApiVO(Boolean enable, String radiusProfileId, Integer macFormat, List<Dot1xEapSettingOpenApiVO> eaps) {
        this.enable = enable;
        this.radiusProfileId = radiusProfileId;
        this.macFormat = macFormat;
        this.eaps = eaps;
    }

    @Generated
    public Dot1xEapOpenApiVO() {
    }
}

