/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xEapPortInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.embed.Dot1xEapInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class Dot1xEapInfoOpenApiVO {
    @Schema(name="name", description="EAP name")
    private String name;
    @Schema(name="mac", description="EAP MAC address")
    @a
    private String mac;
    @Schema(name="model", description="EAP model")
    private String model;
    @Schema(name="version", description="EAP firmwareVersion")
    private String version;
    @Schema(name="status", description="Device status")
    private String status;
    @Schema(name="statusCategory", description="Device status category, 0: Disconnected, 1: Connected, 2: Pending,3: Heartbeat Missed, 4: Isolated")
    private Integer statusCategory;
    @Schema(name="ports", description="EAP port information")
    @Valid
    private List<Dot1xEapPortInfoOpenApiVO> ports;

    public static Dot1xEapInfoOpenApiVO toDot1xEapInfoOpenApiVO(Dot1xEapInfoVO vo) {
        Dot1xEapInfoOpenApiVO openApiVO = new Dot1xEapInfoOpenApiVO();
        openApiVO.setName(vo.getName());
        openApiVO.setMac(vo.getMac());
        openApiVO.setModel(vo.getModel());
        openApiVO.setVersion(vo.getVersion());
        openApiVO.setStatus(Optional.ofNullable(DeviceStatusEnum.a((Integer)vo.getStatus())).map(DeviceStatusEnum::m).orElse(Integer.toString(vo.getStatus())));
        openApiVO.setStatusCategory(vo.getStatusCategory());
        openApiVO.setPorts(CollectionUtils.isEmpty((Collection)vo.getPorts()) ? Collections.emptyList() : vo.getPorts().stream().map(Dot1xEapPortInfoOpenApiVO::toDot1xEapPortInfoOpenApiVO).collect(Collectors.toList()));
        return openApiVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public List<Dot1xEapPortInfoOpenApiVO> getPorts() {
        return this.ports;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
    }

    @Generated
    public void setPorts(List<Dot1xEapPortInfoOpenApiVO> ports) {
        this.ports = ports;
    }

    @Generated
    public String toString() {
        return "Dot1xEapInfoOpenApiVO(name=" + this.getName() + ", mac=" + this.getMac() + ", model=" + this.getModel() + ", version=" + this.getVersion() + ", status=" + this.getStatus() + ", statusCategory=" + this.getStatusCategory() + ", ports=" + this.getPorts() + ")";
    }

    @Generated
    public Dot1xEapInfoOpenApiVO(String name, String mac, String model, String version, String status, Integer statusCategory, List<Dot1xEapPortInfoOpenApiVO> ports) {
        this.name = name;
        this.mac = mac;
        this.model = model;
        this.version = version;
        this.status = status;
        this.statusCategory = statusCategory;
        this.ports = ports;
    }

    @Generated
    public Dot1xEapInfoOpenApiVO() {
    }
}

