/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.global.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.MailServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class SendMailServerOpenApiVO {
    @Schema(name="smtpEnable", description="Enable SMTP mail server")
    private Boolean smtpEnable;
    @Schema(name="smtpServer", description="The domain name of the SMTP mailbox server.")
    @NotNull(message="smtpServer should not be null")
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="smtpServer should not be null") @Pattern(regexp="^[\\041-\\0176]{1,128}$") String smtpServer;
    @Schema(name="port", description="The port of the SMTP mailbox server,xxxx  should be within the range of 1-65535")
    @NotNull(message="port should not be null")
    @Range(min=1L, max=65535L)
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="port should not be null") @Range(min=1L, max=65535L) Integer port;
    @Schema(name="sslEnable", description="Whether the SMTP mailbox server uses SSL encryption.")
    @NotNull(message="sslEnable should not be null")
    private @NotNull(message="sslEnable should not be null") Boolean sslEnable;
    @Schema(name="authEnable", description="Whether the SMTP email server uses basic authentication.")
    @NotNull(message="authEnable should not be null")
    private @NotNull(message="authEnable should not be null") Boolean authEnable;
    @Schema(name="username", description="The user's email address used for authentication.")
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String username;
    @Schema(name="password", description="The user's email password used for authentication.")
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String password;
    @Schema(name="senderAddress", description="The email address from which the message was sent.")
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String senderAddress;
    @Schema(name="receiver", description="The email address where the message will be received.")
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String receiver;

    public static SendMailServerOpenApiVO fromWebVO(MailServerVO vo) {
        if (vo == null) {
            return null;
        }
        SendMailServerOpenApiVO sendMailServerOpenApiVO = new SendMailServerOpenApiVO();
        sendMailServerOpenApiVO.setSmtpEnable(vo.getSmtpEnable());
        sendMailServerOpenApiVO.setSmtpServer(vo.getSmtpServer());
        sendMailServerOpenApiVO.setPort(vo.getPort());
        sendMailServerOpenApiVO.setSslEnable(vo.getSslEnable());
        sendMailServerOpenApiVO.setAuthEnable(vo.getAuthEnable());
        sendMailServerOpenApiVO.setUsername(vo.getUsername());
        sendMailServerOpenApiVO.setPassword(vo.getPassword());
        sendMailServerOpenApiVO.setSenderAddress(vo.getSenderAddress());
        sendMailServerOpenApiVO.setReceiver(vo.getReceiver());
        return sendMailServerOpenApiVO;
    }

    @Generated
    public Boolean getSmtpEnable() {
        return this.smtpEnable;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    @Generated
    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSenderAddress() {
        return this.senderAddress;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public void setSmtpEnable(Boolean smtpEnable) {
        this.smtpEnable = smtpEnable;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    @Generated
    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public String toString() {
        return "SendMailServerOpenApiVO(smtpEnable=" + this.getSmtpEnable() + ", smtpServer=" + this.getSmtpServer() + ", port=" + this.getPort() + ", sslEnable=" + this.getSslEnable() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", senderAddress=" + this.getSenderAddress() + ", receiver=" + this.getReceiver() + ")";
    }

    @Generated
    public SendMailServerOpenApiVO() {
    }

    @Generated
    public SendMailServerOpenApiVO(Boolean smtpEnable, String smtpServer, Integer port, Boolean sslEnable, Boolean authEnable, String username, String password, String senderAddress, String receiver) {
        this.smtpEnable = smtpEnable;
        this.smtpServer = smtpServer;
        this.port = port;
        this.sslEnable = sslEnable;
        this.authEnable = authEnable;
        this.username = username;
        this.password = password;
        this.senderAddress = senderAddress;
        this.receiver = receiver;
    }
}

