/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.global.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="Remote Log")
public class RemoteLogOpenApiVO {
    @Schema(name="enable", description="Whether to enable the feature")
    @NotNull(message="Syslog parameter [enable] should not be null.")
    private @NotNull(message="Syslog parameter [enable] should not be null.") Boolean enable;
    @Schema(name="host", description="The IP address of the remote log server")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Syslog parameter [host] should be IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Syslog parameter [host] should be IP address.") String host;
    @Schema(name="port", description="Port of the remote log server, port should be within the range of 1-65535")
    @Range(min=1L, max=65535L, message="Syslog parameter [port] should between 1 and 65535.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Range(min=1L, max=65535L, message="Syslog parameter [port] should between 1 and 65535.") Integer port;

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public String toString() {
        return "RemoteLogOpenApiVO(enable=" + this.getEnable() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    @Generated
    public RemoteLogOpenApiVO() {
    }

    @Generated
    public RemoteLogOpenApiVO(Boolean enable, String host, Integer port) {
        this.enable = enable;
        this.host = host;
        this.port = port;
    }
}

