/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.global.vo;

import com.tplink.smb.omada.manager.configuration.api.openapi.global.vo.RadiusServerCertificateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.RadiusServerCertificateVO;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.RadiusServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import lombok.Generated;

@Schema(name="Built In Radius Server Setting")
public class RadiusServerConfigOpenApiVO {
    @Schema(name="enable", description="Whether the Built-In RADIUS server is enabled.")
    @NotNull(message="Parameter [enable] should not be null")
    private @NotNull(message="Parameter [enable] should not be null") Boolean enable;
    @Schema(name="authServerPort", description="Server port.")
    @NotNull(message="Parameter [authServerPort] should not be null")
    private @NotNull(message="Parameter [authServerPort] should not be null") Integer authServerPort;
    @Schema(name="secret", description="Server secrect.")
    @NotNull(message="Parameter [secret] should not be null")
    private @NotNull(message="Parameter [secret] should not be null") String secret;
    @Schema(name="tunnelReplyEnable", description="Whether the Tunneled Reply is enabled.")
    @NotNull(message="Parameter [tunnelReplyEnable] should not be null")
    private @NotNull(message="Parameter [tunnelReplyEnable] should not be null") Boolean tunnelReplyEnable;
    @Schema(name="serverAddressType", description="Built In RADIUS server address type, 0: Auto generated, 1: Custom")
    @NotNull(message="Parameter [serverAddressType] should not be null")
    private @NotNull(message="Parameter [serverAddressType] should not be null") Integer serverAddressType;
    @Schema(name="customAddress", description="Customize server address, required when parameter [serverAddressType] is 1.")
    private String customAddress;
    @Schema(name="radiusServerCertificate", description="RADIUS server certificate")
    private RadiusServerCertificateOpenApiVO radiusServerCertificate;

    public static RadiusServerVO toRadiusServerVO(RadiusServerConfigOpenApiVO config) {
        return RadiusServerVO.builder().enable(config.getEnable()).authServerPort(config.getAuthServerPort()).secret(config.getSecret()).tunnelReplyEnable(config.getTunnelReplyEnable()).serverAddressType(config.getServerAddressType()).customAddress(config.getCustomAddress()).radiusServerCertificate((RadiusServerCertificateVO)Optional.ofNullable(config.getRadiusServerCertificate()).map(RadiusServerCertificateOpenApiVO::toRadiusServerCertificateVO).orElse(null)).build();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getAuthServerPort() {
        return this.authServerPort;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public Boolean getTunnelReplyEnable() {
        return this.tunnelReplyEnable;
    }

    @Generated
    public Integer getServerAddressType() {
        return this.serverAddressType;
    }

    @Generated
    public String getCustomAddress() {
        return this.customAddress;
    }

    @Generated
    public RadiusServerCertificateOpenApiVO getRadiusServerCertificate() {
        return this.radiusServerCertificate;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setAuthServerPort(Integer authServerPort) {
        this.authServerPort = authServerPort;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setTunnelReplyEnable(Boolean tunnelReplyEnable) {
        this.tunnelReplyEnable = tunnelReplyEnable;
    }

    @Generated
    public void setServerAddressType(Integer serverAddressType) {
        this.serverAddressType = serverAddressType;
    }

    @Generated
    public void setCustomAddress(String customAddress) {
        this.customAddress = customAddress;
    }

    @Generated
    public void setRadiusServerCertificate(RadiusServerCertificateOpenApiVO radiusServerCertificate) {
        this.radiusServerCertificate = radiusServerCertificate;
    }

    @Generated
    public String toString() {
        return "RadiusServerConfigOpenApiVO(enable=" + this.getEnable() + ", authServerPort=" + this.getAuthServerPort() + ", secret=" + this.getSecret() + ", tunnelReplyEnable=" + this.getTunnelReplyEnable() + ", serverAddressType=" + this.getServerAddressType() + ", customAddress=" + this.getCustomAddress() + ", radiusServerCertificate=" + this.getRadiusServerCertificate() + ")";
    }

    @Generated
    public RadiusServerConfigOpenApiVO() {
    }

    @Generated
    public RadiusServerConfigOpenApiVO(Boolean enable, Integer authServerPort, String secret, Boolean tunnelReplyEnable, Integer serverAddressType, String customAddress, RadiusServerCertificateOpenApiVO radiusServerCertificate) {
        this.enable = enable;
        this.authServerPort = authServerPort;
        this.secret = secret;
        this.tunnelReplyEnable = tunnelReplyEnable;
        this.serverAddressType = serverAddressType;
        this.customAddress = customAddress;
        this.radiusServerCertificate = radiusServerCertificate;
    }
}

