/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.global.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="Portal Port")
public class PortalPortOpenApiVO {
    @Schema(name="portalHttpPort", description="Portal HTTP Port should be 80 or between 1024 and 65535")
    @NumberSet(value={80}, ranges={@Range(min=1024L, max=65535L)}, message="Portal HTTP Port should be 80 or between 1024 and 65535")
    private Integer portalHttpPort;
    @Schema(name="portalHttpsPort", description="Portal HTTPS Port should be between 1024 and 65535")
    @NumberSet(ranges={@Range(min=1024L, max=65535L)}, message="Portal HTTPS Port should be between 1024 and 65535")
    private Integer portalHttpsPort;
    @Schema(name="autoPortalIpEnable", description="Auto portal IP enable status")
    private Boolean autoPortalIpEnable;
    @Schema(name="portalHttpsRedirect", description="Portal HTTPS redirect status")
    private Boolean portalHttpsRedirect;
    @Schema(name="portalHost", description="Portal Host should be a domain name or IP address")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Illegal Portal Host config, it should be a domain name or IP address")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Illegal Portal Host config, it should be a domain name or IP address") String portalHost;

    @Generated
    public Integer getPortalHttpPort() {
        return this.portalHttpPort;
    }

    @Generated
    public Integer getPortalHttpsPort() {
        return this.portalHttpsPort;
    }

    @Generated
    public Boolean getAutoPortalIpEnable() {
        return this.autoPortalIpEnable;
    }

    @Generated
    public Boolean getPortalHttpsRedirect() {
        return this.portalHttpsRedirect;
    }

    @Generated
    public String getPortalHost() {
        return this.portalHost;
    }

    @Generated
    public void setPortalHttpPort(Integer portalHttpPort) {
        this.portalHttpPort = portalHttpPort;
    }

    @Generated
    public void setPortalHttpsPort(Integer portalHttpsPort) {
        this.portalHttpsPort = portalHttpsPort;
    }

    @Generated
    public void setAutoPortalIpEnable(Boolean autoPortalIpEnable) {
        this.autoPortalIpEnable = autoPortalIpEnable;
    }

    @Generated
    public void setPortalHttpsRedirect(Boolean portalHttpsRedirect) {
        this.portalHttpsRedirect = portalHttpsRedirect;
    }

    @Generated
    public void setPortalHost(String portalHost) {
        this.portalHost = portalHost;
    }

    @Generated
    public String toString() {
        return "PortalPortOpenApiVO(portalHttpPort=" + this.getPortalHttpPort() + ", portalHttpsPort=" + this.getPortalHttpsPort() + ", autoPortalIpEnable=" + this.getAutoPortalIpEnable() + ", portalHttpsRedirect=" + this.getPortalHttpsRedirect() + ", portalHost=" + this.getPortalHost() + ")";
    }

    @Generated
    public PortalPortOpenApiVO() {
    }

    @Generated
    public PortalPortOpenApiVO(Integer portalHttpPort, Integer portalHttpsPort, Boolean autoPortalIpEnable, Boolean portalHttpsRedirect, String portalHost) {
        this.portalHttpPort = portalHttpPort;
        this.portalHttpsPort = portalHttpsPort;
        this.autoPortalIpEnable = autoPortalIpEnable;
        this.portalHttpsRedirect = portalHttpsRedirect;
        this.portalHost = portalHost;
    }
}

