/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.global.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="DST Time")
public class DstTimeOpenApiVO {
    @NotNull(message="Daylight saving parameter [month] should not be null.")
    @Range(min=1L, max=12L, message="Daylight saving parameter [month] should between 1 and 12.")
    @Schema(name="month", description="Month of the DST config should be a value as follows: 1: January; 2: February; 3: March; 4: April; 5: May; 6: June; 7: July; 8: August; 9: September; 10: October; 11: November; 12: December.")
    private @NotNull(message="Daylight saving parameter [month] should not be null.") @Range(min=1L, max=12L, message="Daylight saving parameter [month] should between 1 and 12.") Integer month;
    @NotNull(message="Daylight saving parameter [serial] should not be null.")
    @Range(min=1L, max=5L, message="Daylight saving parameter [serial] should between 1 and 5.")
    @Schema(name="serial", description="Week of the DST config should be a value as follows: 1: 1st; 2: 2nd; 3: 3rd; 4: 4th; 5: Last.")
    private @NotNull(message="Daylight saving parameter [serial] should not be null.") @Range(min=1L, max=5L, message="Daylight saving parameter [serial] should between 1 and 5.") Integer serial;
    @NotNull(message="Daylight saving parameter [day] should not be null.")
    @Range(min=1L, max=7L, message="Daylight saving parameter [day] should between 1 and 7.")
    @Schema(name="day", description="Day of the DST config should be a value as follows: 1: Monday; 2: Tuesday; 3: Wednesday; 4: Thursday; 5: Friday; 6: Saturday; 7: Sunday.")
    private @NotNull(message="Daylight saving parameter [day] should not be null.") @Range(min=1L, max=7L, message="Daylight saving parameter [day] should between 1 and 7.") Integer day;
    @NotNull(message="Daylight saving parameter [hour] should not be null.")
    @Range(min=0L, max=23L, message="Daylight saving parameter [hour] should between 0 and 23.")
    @Schema(name="hour", description="Hour of the DST config should be within the range of 0\u201323.")
    private @NotNull(message="Daylight saving parameter [hour] should not be null.") @Range(min=0L, max=23L, message="Daylight saving parameter [hour] should between 0 and 23.") Integer hour;
    @NotNull(message="Daylight saving parameter [minute] should not be null.")
    @Range(min=0L, max=59L, message="Daylight saving parameter [minute] should between 0 and 59.")
    @Schema(name="minute", description="Minute of the DST config should be within the range of 0\u201359.")
    private @NotNull(message="Daylight saving parameter [minute] should not be null.") @Range(min=0L, max=59L, message="Daylight saving parameter [minute] should between 0 and 59.") Integer minute;

    @Generated
    public void setMonth(Integer month) {
        this.month = month;
    }

    @Generated
    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    @Generated
    public void setDay(Integer day) {
        this.day = day;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public Integer getMonth() {
        return this.month;
    }

    @Generated
    public Integer getSerial() {
        return this.serial;
    }

    @Generated
    public Integer getDay() {
        return this.day;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public String toString() {
        return "DstTimeOpenApiVO(month=" + this.getMonth() + ", serial=" + this.getSerial() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ")";
    }

    @Generated
    public DstTimeOpenApiVO() {
    }

    @Generated
    public DstTimeOpenApiVO(Integer month, Integer serial, Integer day, Integer hour, Integer minute) {
        this.month = month;
        this.serial = serial;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }
}

