/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.DslSettingsOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import lombok.Generated;

@Schema(name="GatewayPortConfig")
public class PortConfigOpenApiVO {
    @Schema(name="port", description="Port serial number")
    @NotNull(message="Parameter [port] should not be null")
    private @NotNull(message="Parameter [port] should not be null") Integer port;
    @Schema(name="linkSpeed", description="Port link speed should be a value as follows: 0: Auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2500M; 5: 10G; 6: 5G")
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6}, message="Parameter [linkSpeed] should be [0, 1, 2, 3, 4, 5, 6]")
    private Integer linkSpeed;
    @Schema(name="duplex", description="Port duplex mode should be a value as follows: 0: Auto; 1: Half; 2: Full")
    @NumberSet(value={0, 1, 2}, message="Parameter [duplex] should be 0 or 1 or 2")
    private Integer duplex;
    @Schema(name="mirrorEnable", description="Port enabled mirror or not")
    private Boolean mirrorEnable;
    @Schema(name="mirroredPorts", description="Mirrored Ports Set")
    private Set<Integer> mirroredPorts;
    @Schema(name="mirrorMode", description="Port mirror mode should be a value as follows: 0: ingress; 1: egress; 2: ingress and egress")
    private Integer mirrorMode;
    @Schema(name="pvid", description="Pvid(only for lan port.)")
    private Integer pvid;
    @Schema(name="flowControl", description="Enable flow control or not.(When the port supports flow control.)")
    private Boolean flowControl;
    @Schema(name="status", description="Enable port or not, status should be a value as follows: 0: disable; 1: enable.(When the port supports status.)")
    @NumberSet(value={0, 1}, message="Parameter [status] should be 0 or 1")
    private Integer status;
    @Schema(name="dslSettings", description="DSL port configurations.")
    private DslSettingsOpenApiVO dslSettings;

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Boolean getMirrorEnable() {
        return this.mirrorEnable;
    }

    @Generated
    public Set<Integer> getMirroredPorts() {
        return this.mirroredPorts;
    }

    @Generated
    public Integer getMirrorMode() {
        return this.mirrorMode;
    }

    @Generated
    public Integer getPvid() {
        return this.pvid;
    }

    @Generated
    public Boolean getFlowControl() {
        return this.flowControl;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public DslSettingsOpenApiVO getDslSettings() {
        return this.dslSettings;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setMirrorEnable(Boolean mirrorEnable) {
        this.mirrorEnable = mirrorEnable;
    }

    @Generated
    public void setMirroredPorts(Set<Integer> mirroredPorts) {
        this.mirroredPorts = mirroredPorts;
    }

    @Generated
    public void setMirrorMode(Integer mirrorMode) {
        this.mirrorMode = mirrorMode;
    }

    @Generated
    public void setPvid(Integer pvid) {
        this.pvid = pvid;
    }

    @Generated
    public void setFlowControl(Boolean flowControl) {
        this.flowControl = flowControl;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setDslSettings(DslSettingsOpenApiVO dslSettings) {
        this.dslSettings = dslSettings;
    }

    @Generated
    public String toString() {
        return "PortConfigOpenApiVO(port=" + this.getPort() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", mirrorEnable=" + this.getMirrorEnable() + ", mirroredPorts=" + this.getMirroredPorts() + ", mirrorMode=" + this.getMirrorMode() + ", pvid=" + this.getPvid() + ", flowControl=" + this.getFlowControl() + ", status=" + this.getStatus() + ", dslSettings=" + this.getDslSettings() + ")";
    }
}

