/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgSnmpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class OsgSnmpOpenApiVO {
    @Schema(name="location", description="Location, location should contain 0 to 128 ASCII characters, spaces are allowed, and leading and trailing spaces are not allowed.")
    @Pattern(regexp="^[!-~][\\040-\\0176]{0,126}[!-~]$|^[!-~]$|$", message="SNMP parameter [location] should be 0 to 128 ASCII characters, spaces are allowed, and leading and trailing spaces are not allowed.")
    private @Pattern(regexp="^[!-~][\\040-\\0176]{0,126}[!-~]$|^[!-~]$|$", message="SNMP parameter [location] should be 0 to 128 ASCII characters, spaces are allowed, and leading and trailing spaces are not allowed.") String location;
    @Schema(name="contact", description="Contact, contact should contain 0 to 128 ASCII characters, spaces are not allowed.")
    @Pattern(regexp="^[\\041-\\0176]{0,128}$", message="SNMP parameter [contact] should be 0 to 128 ASCII characters, spaces are not allowed.")
    private @Pattern(regexp="^[\\041-\\0176]{0,128}$", message="SNMP parameter [contact] should be 0 to 128 ASCII characters, spaces are not allowed.") String contact;

    public static OsgSnmpVO toWebVO(OsgSnmpOpenApiVO vo) {
        if (vo == null) {
            return null;
        }
        OsgSnmpVO resp = new OsgSnmpVO();
        resp.setLocation(vo.getLocation());
        resp.setContact(vo.getContact());
        return resp;
    }

    public static OsgSnmpOpenApiVO fromWebVO(OsgSnmpVO vo) {
        if (vo == null) {
            return null;
        }
        OsgSnmpOpenApiVO resp = new OsgSnmpOpenApiVO();
        resp.setLocation(vo.getLocation());
        resp.setContact(vo.getContact());
        return resp;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getContact() {
        return this.contact;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setContact(String contact) {
        this.contact = contact;
    }

    @Generated
    public String toString() {
        return "OsgSnmpOpenApiVO(location=" + this.getLocation() + ", contact=" + this.getContact() + ")";
    }
}

